package com.bxm.localnews.news.vo;

import com.alibaba.fastjson.JSONArray;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.StringUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;
import java.util.List;

@ApiModel(description = "新闻详情")
public class News {

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("新闻标题")
    private String title;

    @ApiModelProperty("内容中：新闻网络图片地址（json字符串格式）如：" +
            "[\"xxxxxxxxxxx.jpg?x-oss-process=style/thumbnail\"," +
            " \"xxxxxxxxxxx.jpg?x-oss-process=style/thumbnail\"]")
    private String imgUrl;

    @JsonIgnore
    @ApiModelProperty("作者头像")
    private String authorImg;

    @ApiModelProperty("来源作者")
    private String author;

    @ApiModelProperty("来源地址")
    @JsonIgnore
    private String address;

    @ApiModelProperty("分类id（一篇文章对应一个分类）")
    private Integer kindId;

    @ApiModelProperty("分享次数")
    private Long shares;

    @ApiModelProperty("浏览次数")
    private Long views;

    @ApiModelProperty("新闻抓取时间")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT, timezone = "GMT+8")
    private Date addTime;

    @ApiModelProperty("新闻修改时间")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT, timezone = "GMT+8")
    private Date modifyTime;

    @ApiModelProperty("新闻发布时间")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT, timezone = "GMT+8")
    private Date publishTime;

    @ApiModelProperty("新闻展示时间")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT, timezone = "GMT+8")
    private Date issueTime;

    @ApiModelProperty("状态 0:抓取中 1：可用  2：失效")
    private Byte status;

    @ApiModelProperty("是否置顶 1：否 2：是")
    private Byte top;

    @ApiModelProperty("新闻类型  1：文章  2：组图  3：视频")
    private Byte type;

    @ApiModelProperty("新闻渠道 1：今日头条 2：搜狐 3:凤凰 4:UC,5网易,6猫扑,7快资讯")
    @JsonIgnore
    private Byte channel;

    @ApiModelProperty("内容")
    private String content;

    @ApiModelProperty("是否是热文 1：否  2：是 3：爆")
    private Byte hot;

    @ApiModelProperty("新闻详情跳转地址")
    private String linkUrl;

    @ApiModelProperty("新闻分享跳转地址")
    private String shareUrl;

    @ApiModelProperty("是否是活动 1：否 2：是")
    private Byte activity;

    @ApiModelProperty("是否是本地新闻 1：否 2：是")
    private Byte local;

    @ApiModelProperty("标签")
    @JsonIgnore
    private Integer showLevel;

    @ApiModelProperty("标签冗余")
    @JsonIgnore
    private String showLevelDetail;

    @ApiModelProperty("投放类型 0全国 1地区")
    private Integer deliveryType;

    @ApiModelProperty("地区冗余")
    private String areaDetail;

    @ApiModelProperty("评论数")
    private Integer comments;

    @ApiModelProperty("是否收藏")
    private Integer collect;

    @JsonIgnore
    private Date topExpireTime;

    @JsonIgnore
    private Date hotExpireTime;

    @JsonIgnore
    private Byte reviewStatus;

    @JsonIgnore
    private Byte kindTop;

    @ApiModelProperty("视频列表")
    @JsonIgnore
    private List<PostImgVo> videoList;

    @ApiModelProperty(value = "视频列表字符串(忽略)",hidden = true)
    private String videoStr;

    @ApiModelProperty(value = "封面图片,如：" +
            "[\"xxxxxxxxxx.jpg?x-oss-process=style/thumbnail\"," +
            " \"xxxxxxxxxx.jpg?x-oss-process=style/thumbnail\"]")
    private String coverList;

    @ApiModelProperty("编辑寄语")
    private String  editorMessage;

    @ApiModelProperty("编辑寄语id")
    private Long editorMessageId;

    @ApiModelProperty("启用占位符")
    private Byte enablePlaceholder=0;

    @ApiModelProperty("封面图片列表")
    private List<PostImgVo> newsImgList;

    @ApiModelProperty("分享图片")
    private PostImgVo shareImg;

    @ApiModelProperty("分享图片")
    private Byte coverSelect;

    public PostImgVo getShareImg() {
        return shareImg;
    }

    public News setShareImg(PostImgVo shareImg) {
        this.shareImg = shareImg;
        return this;
    }

    public List<PostImgVo> getNewsImgList() {
        return newsImgList;
    }

    public News setNewsImgList(List<PostImgVo> newsImgList) {
        this.newsImgList = newsImgList;
        return this;
    }

    public Long getEditorMessageId() {
        return editorMessageId;
    }

    public void setEditorMessageId(Long editorMessageId) {
        this.editorMessageId = editorMessageId;
    }

    public Byte getEnablePlaceholder() {
        return enablePlaceholder;
    }

    public void setEnablePlaceholder(Byte enablePlaceholder) {
        this.enablePlaceholder = enablePlaceholder;
    }

    public String getEditorMessage() {
        return editorMessage;
    }

    public void setEditorMessage(String editorMessage) {
        this.editorMessage = editorMessage;
    }

    public String getCoverList() {
        return coverList;
    }

    public void setCoverList(String coverList) {
        this.coverList = coverList;
    }

    public List<PostImgVo> getVideoList() {
        return videoList;
    }

    public void setVideoList(List<PostImgVo> videoList) {
        this.videoList = videoList;
    }

    public Date getPublishTime() {
        return publishTime;
    }

    public void setPublishTime(Date publishTime) {
        this.publishTime = publishTime;
    }

    public Date getTopExpireTime() {
        return topExpireTime;
    }

    public void setTopExpireTime(Date topExpireTime) {
        this.topExpireTime = topExpireTime;
    }

    public Date getHotExpireTime() {
        return hotExpireTime;
    }

    public void setHotExpireTime(Date hotExpireTime) {
        this.hotExpireTime = hotExpireTime;
    }

    public Byte getReviewStatus() {
        return reviewStatus;
    }

    public void setReviewStatus(Byte reviewStatus) {
        this.reviewStatus = reviewStatus;
    }

    public Byte getKindTop() {
        return kindTop;
    }

    public void setKindTop(Byte kindTop) {
        this.kindTop = kindTop;
    }

    public Integer getCollect() {
        return collect;
    }

    public void setCollect(Integer collect) {
        this.collect = collect;
    }

    public Integer getComments() {
        return comments;
    }

    public void setComments(Integer comments) {
        this.comments = comments;
    }

    public Integer getDeliveryType() {
        return deliveryType;
    }

    public void setDeliveryType(Integer deliveryType) {
        this.deliveryType = deliveryType;
    }

    public String getAreaDetail() {
        return areaDetail;
    }

    public void setAreaDetail(String areaDetail) {
        this.areaDetail = areaDetail;
    }

    public String getShowLevelDetail() {
        return showLevelDetail;
    }

    public void setShowLevelDetail(String showLevelDetail) {
        this.showLevelDetail = showLevelDetail;
    }

    public Integer getShowLevel() {
        return showLevel;
    }

    public void setShowLevel(Integer showLevel) {
        this.showLevel = showLevel;
    }

    public Byte getHot() {
        return this.hot;
    }

    public void setHot(Byte hot) {
        this.hot = hot;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title == null ? null : title.trim();
    }

    public String getImgUrl() {
        return this.imgUrl;
    }

    public void setImgUrl(String imgUrl) {
        if (imgUrl != null) {
            this.imgUrl = StringUtils.equals(imgUrl, "[]") ? null : imgUrl.trim();
        }
    }

    public String getVideoStr() {
        return videoStr;
    }

    public void setVideoStr(String videoStr) {
        this.videoStr = videoStr;
        if (StringUtils.isNotEmpty(videoStr)) {
            this.videoList = JSONArray.parseArray(videoStr,PostImgVo.class);
        }
    }

    public String getAuthorImg() {
        return this.authorImg;
    }

    public void setAuthorImg(String authorImg) {
        this.authorImg = authorImg == null ? null : authorImg.trim();
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author == null ? null : author.trim();
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address == null ? null : address.trim();
    }

    public Integer getKindId() {
        return this.kindId;
    }

    public void setKindId(Integer kindId) {
        this.kindId = kindId;
    }

    public Long getShares() {
        return this.shares;
    }

    public void setShares(Long shares) {
        this.shares = shares;
    }

    public Long getViews() {
        return this.views;
    }

    public void setViews(Long views) {
        this.views = views;
    }

    public Date getAddTime() {
        return this.addTime;
    }

    public void setAddTime(Date addTime) {
        this.addTime = addTime;
    }

    public Date getIssueTime() {
        return this.issueTime;
    }

    public void setIssueTime(Date issueTime) {
        this.issueTime = issueTime;
    }

    public Byte getStatus() {
        return this.status;
    }

    public void setStatus(Byte status) {
        this.status = status;
    }

    public Byte getTop() {
        return this.top;
    }

    public void setTop(Byte top) {
        this.top = top;
    }

    public Byte getType() {
        return this.type;
    }

    public void setType(Byte type) {
        this.type = type;
    }

    public Byte getChannel() {
        return this.channel;
    }

    public void setChannel(Byte channel) {
        this.channel = channel;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content == null ? null : content.trim();
    }

    public String getLinkUrl() {
        return this.linkUrl;
    }

    public void setLinkUrl(String linkUrl) {
        this.linkUrl = linkUrl;
    }

    public Byte getActivity() {
        return activity;
    }

    public void setActivity(Byte activity) {
        this.activity = activity;
    }

    public Byte getLocal() {
        return local;
    }

    public void setLocal(Byte local) {
        this.local = local;
    }

    public Date getModifyTime() {
        return modifyTime;
    }

    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    public String getShareUrl() {
        return shareUrl;
    }

    public void setShareUrl(String shareUrl) {
        this.shareUrl = shareUrl;
    }

    public Byte getCoverSelect() {
        return coverSelect;
    }

    public void setCoverSelect(Byte coverSelect) {
        this.coverSelect = coverSelect;
    }
}