package com.bxm.localnews.news.vo;

import com.bxm.localnews.news.dto.AdvertDTO;
import com.bxm.localnews.news.dto.ForumPostDTO;
import com.bxm.localnews.news.dto.VideoDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

@ApiModel(description = "推荐新闻的返回结果")
public class News4Client {

    @ApiModelProperty("推荐新闻，包括视频新闻、组图新闻")
    private News news;

    @ApiModelProperty("插入的信息流广告,可能为null")
    private AdvertDTO advert;

    @ApiModelProperty("插入的小视频列表，可能为null。列表长度12")
    private List<VideoDto> videos;

    @ApiModelProperty("推荐帖子")
    private ForumPostDTO post;

    @ApiModelProperty("推荐话题")
    private TopicVo recommendTopicVo;

    public News4Client() {
    }

    public News4Client(News news, AdvertDTO advert) {
        this.news = news;
        this.advert = advert;
    }

    public News4Client(News news, AdvertDTO advert,ForumPostDTO post) {
        this.news = news;
        this.advert = advert;
        this.post = post;
    }

    public News4Client(List<VideoDto> videos) {
        this.videos = videos;
    }

    public List<VideoDto> getVideos() {
        return videos;
    }

    public void setVideos(List<VideoDto> videos) {
        this.videos = videos;
    }

    public News getNews() {
        return this.news;
    }

    public void setNews(News news) {
        this.news = news;
    }

    public AdvertDTO getAdvert() {
        return this.advert;
    }

    public void setAdvert(AdvertDTO advert) {
        this.advert = advert;
    }

    public ForumPostDTO getPost() {
        return post;
    }

    public void setPost(ForumPostDTO post) {
        this.post = post;
    }

    public TopicVo getRecommendTopicVo() {
        return recommendTopicVo;
    }

    public void setRecommendTopicVo(TopicVo recommendTopicVo) {
        this.recommendTopicVo = recommendTopicVo;
    }
}
