package com.bxm.localnews.news.vo;

import com.bxm.newidea.component.vo.BaseBean;

import java.util.Objects;

public class NewsKind extends BaseBean {

    /**
     * id
     */
    private Integer id;

    /**
     * 名称
     */
    private String name;

    /**
     * 顺序
     */
    private Integer sortNo;

    /**
     * 是否默认频道（在ios提包时为静默用户添加默认频道）：0否 1是
     */
    private Byte isDefault;

    /**
     * 是否固定频道（添加用户时必须添加的频道）：0否 1是
     */
    private Byte isFix;

    /**
     * 频道类型：1新闻分类 2视频分类
     */
    private Byte kindType;

    /**
     * 是否敏感内容 （在提包时隐藏）:0不隐藏 1隐藏
     */
    private Byte sensitiveFlag;

    /**
     * 是否禁用 0否 1是
     */
    private Byte status;

    public Byte getKindType() {
        return this.kindType;
    }

    public void setKindType(Byte kindType) {
        this.kindType = kindType;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name == null ? null : name.trim();
    }

    public Integer getSortNo() {
        return this.sortNo;
    }

    public void setSortNo(Integer sortNo) {
        this.sortNo = sortNo;
    }

    public Byte getIsDefault() {
        return this.isDefault;
    }

    public void setIsDefault(Byte isDefault) {
        this.isDefault = isDefault;
    }

    public Byte getIsFix() {
        return this.isFix;
    }

    public void setIsFix(Byte isFix) {
        this.isFix = isFix;
    }

    public Byte getSensitiveFlag() {
        return sensitiveFlag;
    }

    public void setSensitiveFlag(Byte sensitiveFlag) {
        this.sensitiveFlag = sensitiveFlag;
    }

    public Byte getStatus() {
        return status;
    }

    public void setStatus(Byte status) {
        this.status = status;
    }

    /**
     * 构建普通标签
     * @param id
     * @param name
     * @return
     */
    public static NewsKind build(Integer id,String name){
        NewsKind newsKind =new NewsKind();
        newsKind.setId(id);
        newsKind.setName(name);
        newsKind.setStatus((byte) 1);
        newsKind.setIsFix((byte) 0);
        return newsKind;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        NewsKind newsKind = (NewsKind) o;
        return Objects.equals(id, newsKind.id) &&
                Objects.equals(name, newsKind.name);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, name);
    }
}