package com.bxm.localnews.news.vo;

import com.bxm.localnews.common.vo.INewsIdSharding;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.vo.BaseBean;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

@ApiModel(description = "新闻回复")
public class OldNewsReply extends BaseBean implements INewsIdSharding {

    private Long id;

    private Long newsId;

    private Long parentId;

    private Long parentUserId;

    private String parentUserNickname;

    private String parentHeadImg;

    private String replyContent;

    private Long userId;

    private String userNickname;

    private String headImg;

    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT, timezone = "GMT+8")
    private Date addTime;

    @ApiModelProperty("删除标记，1已删除")
    private byte deleteFlag = 0;

    public OldNewsReply() {
    }

    public OldNewsReply(String parentUserNickname, String parentHeadImg, Long parentUserId) {
        this.parentUserId = parentUserId;
        this.parentUserNickname = parentUserNickname;
        this.parentHeadImg = parentHeadImg;
    }

    public OldNewsReply(Long userId, String userNickname, String headImg) {
        this.userId = userId;
        this.userNickname = userNickname;
        this.headImg = headImg;
    }

    @ApiModelProperty("回复的根id 直接评论新闻则是0，回复新闻下的评论则显示新闻评论id")
    private Long rootId;

    @ApiModelProperty("回复层次 0:直接评论新闻 1:回复新闻下的评论 2:回复新闻下评论的回复")
    private Byte level;

    @ApiModelProperty("回复点赞数")
    private Integer likeCount;

    @ApiModelProperty("类型：1.新闻  2.小视频")
    private Byte type;

    @ApiModelProperty("状态")
    private Byte status;

    @ApiModelProperty("互动值")
    private Integer interactiveCount;

    public byte getDeleteFlag() {
        return this.deleteFlag;
    }

    public void setDeleteFlag(byte deleteFlag) {
        this.deleteFlag = deleteFlag;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getNewsId() {
        return this.newsId;
    }

    public void setNewsId(Long newsId) {
        this.newsId = newsId;
    }

    public Long getParentId() {
        return this.parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public Long getParentUserId() {
        return this.parentUserId;
    }

    public void setParentUserId(Long parentUserId) {
        this.parentUserId = parentUserId;
    }

    public String getParentUserNickname() {
        return this.parentUserNickname;
    }

    public void setParentUserNickname(String parentUserNickname) {
        this.parentUserNickname = parentUserNickname == null ? null : parentUserNickname.trim();
    }

    public String getParentHeadImg() {
        return this.parentHeadImg;
    }

    public void setParentHeadImg(String parentHeadImg) {
        this.parentHeadImg = parentHeadImg == null ? null : parentHeadImg.trim();
    }

    public String getReplyContent() {
        return this.replyContent;
    }

    public void setReplyContent(String replyContent) {
        this.replyContent = replyContent == null ? null : replyContent.trim();
    }

    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getUserNickname() {
        return this.userNickname;
    }

    public void setUserNickname(String userNickname) {
        this.userNickname = userNickname == null ? null : userNickname.trim();
    }

    public String getHeadImg() {
        return this.headImg;
    }

    public void setHeadImg(String headImg) {
        this.headImg = headImg == null ? null : headImg.trim();
    }

    public Date getAddTime() {
        return this.addTime;
    }

    public void setAddTime(Date addTime) {
        this.addTime = addTime;
    }

    public Long getRootId() {
        return rootId;
    }

    public OldNewsReply setRootId(Long rootId) {
        this.rootId = rootId;
        return this;
    }

    public Byte getLevel() {
        return level;
    }

    public OldNewsReply setLevel(Byte level) {
        this.level = level;
        return this;
    }

    public Integer getLikeCount() {
        return likeCount;
    }

    public OldNewsReply setLikeCount(Integer likeCount) {
        this.likeCount = likeCount;
        return this;
    }

    public Byte getType() {
        return type;
    }

    public OldNewsReply setType(Byte type) {
        this.type = type;
        return this;
    }

    public Byte getStatus() {
        return status;
    }

    public OldNewsReply setStatus(Byte status) {
        this.status = status;
        return this;
    }

    public Integer getInteractiveCount() {
        return interactiveCount;
    }

    public OldNewsReply setInteractiveCount(Integer interactiveCount) {
        this.interactiveCount = interactiveCount;
        return this;
    }
}
