package com.bxm.localnews.news.domain;

import java.util.List;

import com.bxm.localnews.common.vo.MPage;
import com.bxm.localnews.news.dto.NewsReplyDTO;
import com.bxm.localnews.news.vo.MyReceiveReplysVO;
import com.bxm.localnews.news.vo.MyReplysVO;
import com.bxm.localnews.news.vo.NewsReply;

import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

@Mapper
public interface NewsReplyMapper {

    /**
     * 删除用户评论，设置用户评论删除标记为1
     *
     * @param id 评论ID
     * @return
     */
    int deleteByPrimaryKey(Long id);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table a_news_reply
     */
    int insert(NewsReply record);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table a_news_reply
     */
    int insertSelective(NewsReply record);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table a_news_reply
     */
    NewsReply selectByPrimaryKey(Long id);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table a_news_reply
     */
    int updateByPrimaryKeySelective(NewsReply record);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table a_news_reply
     */
    int updateByPrimaryKey(NewsReply record);

    List<NewsReplyDTO> queryParentList(@Param("newsId") Long newsId, @Param("page") MPage page);

    List<NewsReply> selectReplyList(@Param("newsId") Long newsId, @Param("parentId") Long parentId);

    List<MyReplysVO> selectMyReplys(@Param("userId") Long userId, @Param("page") MPage page);

    List<MyReceiveReplysVO> myReceiveReplys(@Param("userId") Long userId, @Param("page") MPage page);

    void updateByUserId(NewsReply user);

    void updateByParentUserId(NewsReply user);

}
