package com.bxm.localnews.news.domain;

import com.bxm.localnews.news.model.param.AdminEditorMessageParam;
import com.bxm.localnews.news.model.param.AdminForumPostParam;
import com.bxm.localnews.news.model.vo.AdminBaseForumPost;
import com.bxm.localnews.news.model.vo.AdminForumPost;
import com.bxm.localnews.news.model.vo.AdminForumPostApproveHistory;
import com.bxm.localnews.news.model.vo.PostTag;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

@Mapper
public interface AdminForumPostMapper {

    List<AdminBaseForumPost> getList(AdminForumPostParam param);

    AdminForumPost selectByPrimaryKey(@Param("id") Long id);

    int insertSelective(AdminForumPost record);

    int updateByIdPartSelective(AdminForumPost record);

    int updateRecommendById(AdminForumPost record);

    int addApproveHistory(@Param("id") Long id,
                          @Param("postId") Long postId,
                          @Param("status") Byte status,
                          @Param("comment") String comment,
                          @Param("createTime") Date createTime,
                          @Param("creator") Long creator);

    List<AdminForumPostApproveHistory> getApproveHistoryList(@Param("id") Long id, @Param("action") Integer action);

    int savePostTag(PostTag postTag);

    int deletePostTag(@Param("postId") Long postId);

    int updateComment(@Param("id") Long id, @Param("comments") int comments);

    int updateEditMessageById(AdminEditorMessageParam param);

    int deleteEditMessageById(Long id);

    int countApproveHistory(@Param("postId") Long postId);

    int updateForumContentByForumId(@Param("forumId") Long forumId, @Param("content") String content);

    int updateForumContentByIdList(@Param("postIdList") List<Long> postIdList, @Param("content") String content);
}