package com.bxm.localnews.news.domain;

import com.bxm.localnews.news.model.param.AdminNewsDetailStatisticsParam;
import com.bxm.localnews.news.model.param.AdminNewsSourceStatisticsParam;
import com.bxm.localnews.news.model.vo.AdminNewsSourceInfoBean;
import com.bxm.localnews.news.model.vo.AdminNewsStatistics;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

@Mapper
public interface AdminNewsStatisticsMapper {
    int save(AdminNewsStatistics adminNewsStatistics);

    int deleteByNewsId(Long newsId);

    /**
     * 根据来源统计新闻信息
     *
     * @param param 统计参数
     * @return 新闻来源统计结果
     */
    List<AdminNewsSourceInfoBean> countWithArea(AdminNewsDetailStatisticsParam param);

    /**
     * 根据新闻来源统计
     *
     * @param param
     * @return
     */
    List<AdminNewsSourceInfoBean> countWithSource(AdminNewsSourceStatisticsParam param);

    int countWithAreaAndTime(@Param("areaCode") String areaCode,
                             @Param("startTime") Date startTime,
                             @Param("endTime") Date endTime,
                             @Param("kindId") Integer kindId);
}
