package com.bxm.localnews.news.domain;

import com.bxm.localnews.news.dto.RelationDTO;
import com.bxm.localnews.news.vo.ForumTopicAreaRelationVo;
import com.bxm.localnews.news.vo.ForumVo;
import com.bxm.localnews.news.vo.PostForumVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Deprecated
@Mapper
public interface ForumMapper {

    /**
     * 根据地区获取状态为可用的板块列表
     * @param areaCode
     * @param enable
     * @return
     */
    List<ForumVo> getForumList(@Param("areaCode") String areaCode, @Param("enable") Integer enable);

    /**
     * 根据id获取板块id
     * @param id
     * @param areaCode
     * @return
     */
    ForumVo selectForumById(@Param("id") Long id, @Param("areaCode") String areaCode);

    /**
     * 根据帖子id列表获取相应的板块列表
     * @param ids
     * @return
     */
    List<PostForumVO> listPostForum(@Param("ids") List<Long> ids);

    /**
     * 根据帖子id列表获取相应的板块id列表
     *
     * @param postIds
     * @return
     */
    List<RelationDTO> getPostForumRelation(@Param("postIds") List<Long> postIds);

    /**
     * 更新板块的参与人数
     * @param forumId
     * @param participantsNum
     * @return
     */
    int updateForum(@Param("forumId") Long forumId, @Param("participantsNum") Integer participantsNum);

    /**
     * 获取版块话题地区信息
     * @return
     */
    List<ForumTopicAreaRelationVo> getAreaRelationList();

    /**
     * 更新地区参与人数信息
     * @return
     */
    int updateAreaParticipantsNum(@Param("id") Long id, @Param("participantsNum") Integer participantsNum);

}