package com.bxm.localnews.news.domain;

import com.bxm.localnews.news.vo.ForumPostLike;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

@Mapper
public interface ForumPostLikeMapper {

    int insertSelective(ForumPostLike record);

    int updateByPrimaryKeySelective(ForumPostLike record);

    ForumPostLike selectByUserIdAndPostId(@Param("userId") Long userId,@Param("postId")Long postId);

    List <ForumPostLike> selectByPostIdAndOrderByAddtime(Long postId);

    List <ForumPostLike> selectPostById(Long postId);

    int updateNotShowPostLike(Date currentTime);

    List<Long> selectNotExitsUserInfo();

    int updateUserInfoByUserId(ForumPostLike record);

    List<ForumPostLike> selectNotShowPostLike();

    /**
     * 根据用户id更新帖子点赞表的用户信息
     * @param userId
     * @param nickName
     * @param headImg
     * @return
     */
    int updateNickNameAndHeadImgByUserId(@Param("userId") Long userId, @Param("nickName")String nickName, @Param("headImg")String headImg);

    Integer getUserPostLike(@Param("postId") Long postId, @Param("userId") Long userId);

    List<Long> listUserPostLike(@Param("userId") Long userId);
}