package com.bxm.localnews.news.domain;

import com.bxm.localnews.news.dto.PostTopicDTO;
import com.bxm.localnews.news.dto.RelationDTO;
import com.bxm.localnews.news.vo.ForumTopicAreaRelationVo;
import com.bxm.localnews.news.vo.TopicSecondInfo;
import com.bxm.localnews.news.vo.TopicVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface ForumTopicMapper {

    /**
     * 根据地区获取状态为可用的话题列表
     *
     * @param areaCode
     * @param enable
     * @return
     */
    List<TopicVo> getTopicList(@Param("areaCode") String areaCode, @Param("enable") Integer enable);

    /**
     * 3.10.0   获取话题二级分类标题
     *
     * @param topicId
     * @return
     */
    List<TopicSecondInfo> getTopicSecondTitle(@Param("topicId") Long topicId);

    /**
     * 根据id获取话题详情
     *
     * @param id
     * @param areaCode
     * @return
     */
    TopicVo selectTopicById(@Param("id") Long id, @Param("areaCode") String areaCode);

    /**
     * 根据帖子id列表获取相应的话题id列表
     *
     * @param postIds
     * @return
     */
    List<RelationDTO> getPostTopicRelation(@Param("postIds") List<Long> postIds);

    /**
     * 删除帖子下的所有话题
     *
     * @param postId
     * @return
     */
    int batchDeleteTopic(@Param("postId") Long postId);

    /**
     * 批量添加帖子与话题的关系
     *
     * @param list
     * @return
     */
    int batchInsertTopic(List<PostTopicDTO> list);

    /**
     * 更新话题的参与人数
     *
     * @param topicId
     * @param participantsNum
     * @return
     */
    int updateTopic(@Param("topicId") Long topicId, @Param("participantsNum") Integer participantsNum);

    /**
     * 获取话题下发帖人头像
     *
     * @param topicId
     * @return
     */
    List<String> getPostHeadImgList(@Param("topicId") Long topicId);

    /**
     * 获取话题下帖子id
     *
     * @param topicId
     * @return
     */
    List<Long> getPostIdListByTopicId(@Param("topicId") Long topicId);

    /**
     * 获取话题下点赞人头像
     *
     * @param topicId
     * @return
     */
    List<String> getLikeHeadImgList(@Param("topicId") Long topicId);

    /**
     * 获取版块话题地区信息
     *
     * @return
     */
    List<ForumTopicAreaRelationVo> getAreaRelationList();

    /**
     * 更新地区参与人数信息
     *
     * @return
     */
    int updateAreaParticipantsNum(@Param("id") Long id, @Param("participantsNum") Integer participantsNum);

    /**
     * 根据地区获取状态为可用最新的一个话题
     *
     * @param areaCode 区域编码
     * @param enable   是否可用
     * @return 当前地区最新的topic
     */
    TopicVo getTopicLatest(@Param("areaCode") String areaCode, @Param("enable") Integer enable);

}
