package com.bxm.localnews.news.domain;

import com.bxm.localnews.news.param.UserReplyParam;
import com.bxm.localnews.news.vo.MyReplysVO;
import com.bxm.localnews.news.vo.UserReply;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface UserReplyMapper {

    /**
     * 插入用户评论
     * @param record
     * @return
     */
    int insertSelective(UserReply record);

    /**
     * 分页 查询我的评论
     * @param newsReplyParam
     * @return
     */
    List<MyReplysVO> selectMyReplys(UserReplyParam newsReplyParam);

    /**
     * 更新点赞数和互动值
     * @param userReply
     * @return
     */
    int updateinteractiveCountById(UserReply userReply);

    /**
     * 新版本删除用户评论
     * 旧版本删除用户评论
     * @param id
     * @param userId
     * @return
     */
    int deleteByPrimaryKey(@Param("id")Long id,@Param("userId")Long userId,@Param("isUserDelete") Byte isUserDelete);

    /**
     * 定时任务相关：更新评论的状态
     * @param userId
     * @param id
     */
    int updateStatus(@Param("userId") Long userId,@Param("id") Long id);

    /**
     * 根据用户id和评论id查找
     * @param id
     * @param userId
     * @return
     */
    UserReply selectByPrimaryKey(@Param("id") Long id,@Param("userId") Long userId);

    int updateUserInfo(UserReply userReply);

    int updateParentUserInfo(UserReply userReply);

    /**
     * 根据用户id 查找用户的评论数
     * @param userId
     * @return
     */
	Integer selectReplyLikeNumByUserId(Long userId);
}
