package com.bxm.localnews.news.domain;

import com.bxm.localnews.news.vo.UserTag;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

@Mapper
public interface UserTagConsumeMapper {

    /**
     * 是否需要重新计算用户标签
     * @param userId 用户ID
     * @param time   判断时间
     * @return 大于0表示重新计算
     */
    int isNeedRecalcu(@Param("userId") Long userId, @Param("time") Date time);

    /**
     * 获取用户标签总数
     * @param userId 用户ID
     * @return 返回0表示用户无标签信息
     */
    int getUserTagCount(Long userId);

    /**
     * 重新统计用户标签信息
     * @param userId 用户ID
     * @return 用户标签列表
     */
    List<UserTag> recountUserTags(Long userId);

    /**
     * 获取新闻类目标签,用于补充用户标签，防止某些类目无法检索的问题
     * @return
     */
    List<UserTag> getKindTags();

    /**
     * 删除用户标签
     * @param userId 用户ID
     * @return 删除结果
     */
    int deleteUserTag(Long userId);

    /**
     * 保存用户标签
     * @param tag 用户标签
     * @return 保存结果
     */
    int insert(UserTag tag);

}