package com.bxm.localnews.news.dto;

import com.bxm.localnews.news.vo.PostImgVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@ApiModel("帖子发布返回实体")
@Data
public class ForumPostCreateDTO extends NewsCompleTaskDTO {

    @ApiModelProperty("新闻分享跳转地址")
    private String shareUrl;

    @ApiModelProperty("小程序分享跳转地址")
    private String appletShareUrl;

    @ApiModelProperty("帖子返回实体")
    private ForumPost forumPost;

    public static class ForumPost{

        @ApiModelProperty("帖子id")
        private Long id;

        @ApiModelProperty("帖子图片以及视频列表")
        private String postImgUrl;

        @ApiModelProperty("帖子文本")
        private String textField;

        @ApiModelProperty("帖子标题")
        private String title;

        public Long getId() {
            return id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getPostImgUrl() {
            return postImgUrl;
        }

        public void setPostImgUrl(String postImgUrl) {
            this.postImgUrl = postImgUrl;
        }

        public String getTextField() {
            return textField;
        }

        public void setTextField(String textField) {
            this.textField = textField;
        }

        public String getTitle() {
            return title;
        }

        public void setTitle(String title) {
            this.title = title;
        }
    }

    public ForumPost getForumPost() {
        return forumPost;
    }

    public void setForumPost(ForumPost forumPost) {
        this.forumPost = forumPost;
    }

    public String getShareUrl() {
        return shareUrl;
    }

    public void setShareUrl(String shareUrl) {
        this.shareUrl = shareUrl;
    }

    public String getAppletShareUrl() {
        return appletShareUrl;
    }

    public void setAppletShareUrl(String appletShareUrl) {
        this.appletShareUrl = appletShareUrl;
    }
}
