package com.bxm.localnews.news.dto;

import com.alibaba.fastjson.annotation.JSONField;
import com.bxm.localnews.news.vo.NewsReply;
import com.bxm.localnews.news.vo.OldNewsReply;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.vo.BaseBean;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ApiModel(description = "新闻评论信息")
public class OldNewsReplyDto extends BaseBean {

    @ApiModelProperty(hidden = true)
    List<OldNewsReply> list = new ArrayList<>(10);

    @ApiModelProperty("评论ID")
    private Long id;

    @ApiModelProperty("新闻ID")
    private Long newsId;

    @ApiModelProperty("评论上级id   0为第一级")
    private Long parentId;

    @ApiModelProperty("被评论用户id")
    private Long parentUserId;

    @ApiModelProperty("被评论用户昵称")
    private String parentUserNickname;

    @ApiModelProperty("被评论用户头像地址")
    private String parentHeadImg;

    @ApiModelProperty("评论内容")
    private String replyContent;

    @ApiModelProperty("评论人用户id")
    private Long userId;

    @ApiModelProperty("评论人昵称")
    private String userNickname;

    @ApiModelProperty("评论人头像地址")
    private String headImg;

    @ApiModelProperty("评论时间")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT, timezone = "GMT+8")
    @JSONField(format = DateUtils.DATE_TIME_FORMAT)
    private Date addTime;

    @ApiModelProperty("是否已删除的评论，1：已删除,0:未删除")
    private byte deleteFlag;

    @ApiModelProperty(hidden = true)
    private Long addTimestamp;

    public byte getDeleteFlag() {
        return this.deleteFlag;
    }

    public void setDeleteFlag(byte deleteFlag) {
        this.deleteFlag = deleteFlag;
    }

    public Long getAddTimestamp() {
        return this.addTimestamp;
    }

    public void setAddTimestamp(Long addTimestamp) {
        this.addTimestamp = addTimestamp;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getNewsId() {
        return this.newsId;
    }

    public void setNewsId(Long newsId) {
        this.newsId = newsId;
    }

    public Long getParentId() {
        return this.parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public Long getParentUserId() {
        return this.parentUserId;
    }

    public void setParentUserId(Long parentUserId) {
        this.parentUserId = parentUserId;
    }

    public String getParentUserNickname() {
        return this.parentUserNickname;
    }

    public void setParentUserNickname(String parentUserNickname) {
        this.parentUserNickname = parentUserNickname;
    }

    public String getParentHeadImg() {
        return this.parentHeadImg;
    }

    public void setParentHeadImg(String parentHeadImg) {
        this.parentHeadImg = parentHeadImg;
    }

    public String getReplyContent() {
        return this.replyContent;
    }

    public void setReplyContent(String replyContent) {
        this.replyContent = replyContent;
    }

    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getUserNickname() {
        return this.userNickname;
    }

    public void setUserNickname(String userNickname) {
        this.userNickname = userNickname;
    }

    public String getHeadImg() {
        return this.headImg;
    }

    public void setHeadImg(String headImg) {
        this.headImg = headImg;
    }

    public Date getAddTime() {
        return this.addTime;
    }

    public void setAddTime(Date addTime) {
        this.addTime = addTime;
    }

    public List<OldNewsReply> getList() {
        return list;
    }

    public OldNewsReplyDto setList(List<OldNewsReply> list) {
        this.list = list;
        return this;
    }
}
