package com.bxm.localnews.news.dto;

import com.bxm.localnews.news.vo.NewsReplyBaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import net.bytebuddy.implementation.bind.annotation.Pipe;

@ApiModel(description = "新闻评论实体")
public class ReplyNewsDTO {

    @ApiModelProperty("新闻id")
    private Long id;

    @ApiModelProperty("总评论数")
    private Integer comments;

    @ApiModelProperty("总收藏数")
    private Integer collect;

    @ApiModelProperty("新闻详情链接地址")
    private String linkUrl;

    @ApiModelProperty("新闻分享链接地址")
    private String shareUrl;

    @ApiModelProperty("状态 0:抓取中 1：可用  2：失效")
    private Byte status;

    @ApiModelProperty("新闻图片")
    private String imgUrl;

    public String getImgUrl() {
        return imgUrl;
    }

    public void setImgUrl(String imgUrl) {
        this.imgUrl = imgUrl;
    }

    public Byte getStatus() {
        return status;
    }

    public void setStatus(Byte status) {
        this.status = status;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getComments() {
        return comments;
    }

    public ReplyNewsDTO setComments(Integer comments) {
        this.comments = comments;
        return this;
    }

    public Integer getCollect() {
        return collect;
    }

    public ReplyNewsDTO setCollect(Integer collect) {
        this.collect = collect;
        return this;
    }

    public String getLinkUrl() {
        return linkUrl;
    }

    public void setLinkUrl(String linkUrl) {
        this.linkUrl = linkUrl;
    }

    public String getShareUrl() {
        return shareUrl;
    }

    public void setShareUrl(String shareUrl) {
        this.shareUrl = shareUrl;
    }
}
