package com.bxm.localnews.news.param;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.news.vo.News;
import com.bxm.localnews.news.vo.NewsGoldMeta;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


@ApiModel(description = "文章阅读奖励参数")
public class ExecGoldParam {

    @ApiModelProperty(value = "新闻ID", required = true)
    private Long newsId;

    @ApiModelProperty(value = "用户id", required = true)
    private Long userId;

    @ApiModelProperty(value = "阅读时间", required = true)
    private Integer viewTime;

    @ApiModelProperty(value = "是否读取到文章末尾 1：否   2：是", required = true)
    private String tabType;

    @ApiModelProperty(value = "广告位是否展示出来 1：否  2：是", required = true)
    private String advertShow;

    @ApiModelProperty(value = "是否是推荐文章  1：否  2：是 (如果是推送文章，进到详情页立即调用该接口)")
    private String isRecommendNews;

    public Long getNewsId() {
        return newsId;
    }

    public void setNewsId(Long newsId) {
        this.newsId = newsId;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Integer getViewTime() {
        return viewTime;
    }

    public void setViewTime(Integer viewTime) {
        this.viewTime = viewTime;
    }

    public String getTabType() {
        return tabType;
    }

    public void setTabType(String tabType) {
        this.tabType = tabType;
    }

    public String getAdvertShow() {
        return advertShow;
    }

    public void setAdvertShow(String advertShow) {
        this.advertShow = advertShow;
    }

    public String getIsRecommendNews() {
        return isRecommendNews;
    }

    public void setIsRecommendNews(String isRecommendNews) {
        this.isRecommendNews = isRecommendNews;
    }


}
