package com.bxm.localnews.news.param;

import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.news.dto.ForumPostLikeDTO;
import com.bxm.localnews.news.dto.NewsReplyDTO;
import com.bxm.localnews.news.dto.VoteDetailDTO;
import com.bxm.localnews.news.vo.*;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "帖子详情")
@Data
public class ForumPostFacadeParam extends BasicParam {

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("地区编码")
    private String areaCode;

    @ApiModelProperty("话题id列表")
    private List<Long> topicIdList;

    @ApiModelProperty("是否新人一键发布 0不是,1是")
    private Byte isNewReport;

    @ApiModelProperty("帖子标题")
    private String title;

    @ApiModelProperty("作者id")
    private Long userId;

    @ApiModelProperty("发帖地址")
    private String location;

    @ApiModelProperty("帖子文本")
    private String textField;

    @ApiModelProperty("帖子图片数组")
    private List<PostImgVo> postImgList;
}
