package com.bxm.localnews.news.param;

import com.bxm.newidea.component.vo.PageParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

@Data
@ApiModel(description = "帖子列表查询")
public class ForumPostListQueryParam extends PageParam {

    @ApiModelProperty("当前用户id")
    @NotNull
    private Long userId;

    @ApiModelProperty("版块id")
    private Long forumId;

    @ApiModelProperty("主题id")
    private Long topicId;

    @ApiModelProperty("类型：0热门 1精选 2最新 3社区首页")
    @NotNull
    private Integer type;

    @ApiModelProperty("推荐方式，1：下拉刷新，2：上拉刷新，首次进入为下拉刷新")
    private Integer recommendType;

    @ApiModelProperty("区域编码")
    private String areaCode;

    @ApiModelProperty("主题id集合：3.3.1新增")
    private String channelIds;

}
