package com.bxm.localnews.news.param;

import com.bxm.localnews.common.vo.BasicParam;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @author zhaoyadong 2018/11/10 17:12
 * @desc
 */
@ApiModel(description = "获取新闻详情的参数")
public class NewsParam extends BasicParam {

    @ApiModelProperty("新闻id")
    private Long newsId;

    @ApiModelProperty("用户id")
    private Long userId;

    @ApiModelProperty(value = "转发者用户id", required = false)
    private Long shareUserId;

    @ApiModelProperty("类型:页面类型 1：app详情页获取数据  2：分享详情页获取数据 3：app用户搜索的文章获取数据")
    private Byte type;

    @ApiModelProperty("地区编码")
    private String areaCode;

    public Long getShareUserId() {
        return shareUserId;
    }

    public void setShareUserId(Long shareUserId) {
        this.shareUserId = shareUserId;
    }

    public Long getNewsId() {
        return newsId;
    }

    public void setNewsId(Long newsId) {
        this.newsId = newsId;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Byte getType() {
        return type;
    }

    public void setType(Byte type) {
        this.type = type;
    }

    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }
}
