package com.bxm.localnews.news.vo;

import com.bxm.localnews.news.dto.ForumPostLikeDTO;
import com.bxm.localnews.news.dto.NewsReplyDTO;
import com.bxm.localnews.news.dto.VoteDetailDTO;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@ApiModel(description = "帖子详情")
@Data
public class ForumPostVo extends ForumBasicVo {

    @ApiModelProperty("作者头像")
    private String userImg;

    @ApiModelProperty("作者名称")
    private String userName;

    @ApiModelProperty("是否是vip：0-不是 1-是")
    private Integer isVip;

    @ApiModelProperty("是否认证商家 0 否  1 是")
    private Integer merchantStatus;

    @ApiModelProperty("认证商家id")
    private Long merchantId;

    @ApiModelProperty("认证商家名称")
    private String merchantName;

    @ApiModelProperty("帖子封面图片")
    @JsonIgnore
    private String coverList;

    @ApiModelProperty("帖子内容")
    private String content;

    @ApiModelProperty("是否精华帖：0否 1是")
    private Integer isBrilliant;

    @ApiModelProperty("是否本地爆料：0否 1是")
    private Byte isBroke;

    @ApiModelProperty("是否优质头条：0否 1是")
    private Byte isRecommend;

    @ApiModelProperty("是否红色章：0否 1是")
    private Integer isRed;

    @ApiModelProperty("是否奖励现金：0否 1是")
    private Integer isCash;

    @ApiModelProperty("发布时间")
    private String displayTime;

    @ApiModelProperty("阅读数")
    private Integer clickCount;

    @ApiModelProperty("有效阅读总数（3.8.0定义为真实阅读数量）")
    private Long reviewCount;

    @ApiModelProperty("初始基数")
    private Long initialBasicNum;

    @ApiModelProperty("该帖子最终需要达到的用户阅读数量（由真实阅读数量计算而来）")
    private Long finalClickCount;

    @ApiModelProperty("评论数")
    private Integer commentCount;

    @ApiModelProperty("更多评论数")
    private Integer moreCommentCount;

    @ApiModelProperty("分享数")
    private Integer shareCount;

    @ApiModelProperty("收藏数")
    private Integer collectCount;

    @ApiModelProperty(value = "推荐次数", hidden = true)
    private Integer recommendCount;

    @ApiModelProperty("点赞次数")
    private Integer likeCount;

    @ApiModelProperty("当前用户是否已点赞：0否 1是")
    private Integer liked;

    @ApiModelProperty("当前用户是否已收藏：0否 1是")
    private Integer collected;

    @ApiModelProperty("版块")
    private ForumVo forum;

    @ApiModelProperty("话题列表")
    private List<TopicVo> topicList;

    @ApiModelProperty("审核状态：1通过 2审核中 3拒绝 ... 100:限制内容被访问")
    private Integer status;

    @ApiModelProperty("帖子分享链接")
    private String shareUrl;

    @ApiModelProperty("是否强引导下载  0:否 1:是")
    private Byte isBootDownload;

    @ApiModelProperty("现金奖励金额")
    private BigDecimal cashReward;

    @ApiModelProperty("评论信息")
    private List<NewsReplyDTO> replyInfo;

    @ApiModelProperty("热评")
    private List<NewsReplyDTO> hotReplyDesc;

    @ApiModelProperty("点赞信息")
    private List<ForumPostLikeDTO> likeInfo;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("发布时间")
    private Date publishTime;

    @ApiModelProperty("展示时间")
    private Date displayDateTime;

    @ApiModelProperty("展示标签：1热 2爆 3自定义")
    private Byte displayTag;

    @ApiModelProperty("自定义标签内容")
    private String labelDiv;

    @ApiModelProperty("剩下的评论数量，如果replyInfo为空则不用显示")
    private Integer leftRelyNum = 0;

    @ApiModelProperty("微信小程序分享url")
    private String appletShareUrl;

    @ApiModelProperty("编辑寄语")
    private String editorMessage;

    @ApiModelProperty("启用占位符 0 未启用 1启用")
    private Byte enablePlaceholder;

    @ApiModelProperty("内容中的图片")
    private List<PostImgVo> postContentImgList;

    @ApiModelProperty("更新时间")
    private Date modifyTime;

    @ApiModelProperty("用户是否首次发帖 0 否 1是")
    private Byte isFirstUserPost=0;

    @ApiModelProperty("分享图片")
    private PostImgVo shareImg;

    @ApiModelProperty("投票插件信息，可能为空")
    private VoteDetailDTO voteDetailDTO;

    @ApiModelProperty("推荐话题")
    private TopicVo recommendTopicVo;

    @ApiModelProperty(value = "帖子插件信息", hidden = true)
    @JsonIgnore
    private List<ForumPlugin> plugins;

    @ApiModelProperty("是否用户修改")
    private Byte isUserUpdate;

    @ApiModelProperty("投放类型 0全国 1地区")
    private Integer deliveryType;

    @Deprecated
    @ApiModelProperty("到期时间 3.4.0版本之后小纸条暂时移除失效时间")
    private Date validDate;

    @ApiModelProperty("马甲号类型 0:正常用户 1:评论马甲  2:发帖马甲 3:普通陪聊 4:地方大V 5:全国大V")
    private Byte vestType;

    @ApiModelProperty("广告内容")
    private List<AdvertVO> advertList;

    @ApiModelProperty("帖子拓展跳转信息")
    private ExtJumpInfo extJumpInfo;

    @ApiModelProperty("3.10.0需求-话题页 “最新”tab顶部引导到“最热”tab数据内容")
    private TopicHotForumGuideInfo topicHotForumGuideInfo;
}
