package com.bxm.localnews.news.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 本地圈面包块视图类
 *
 * @author wzy
 * @version 1.0
 * @date 2020/9/18 2:21 下午
 */
@Data
@ApiModel("本地圈面包块视图对象")
public class LocalCrumbs {

    @ApiModelProperty("名称,可在Apollo进行配置")
    private String name;

    @ApiModelProperty("最新消息条数")
    private Long latestCount = 0L;

    @ApiModelProperty(value = "面包块类型", example = "1:话题广场，2：同城交友")
    private Integer type;

    @ApiModelProperty("点击面包块跳转地址")
    private String jumpUrl;

    @ApiModelProperty("面包块的背景图片地址")
    private String backgroundImgUrl;

    @ApiModelProperty("面包块扩展数据：type为1：话题广场，则extData对象结构为：latestTopicId（最新话题id，类型long），latestTopicTitle（最新话题标题,类型 String）" +
            "type为2：同城交友，则extData返回 headImages （头像列表，类型List<String>））")
    private Object extData;
}