package com.bxm.localnews.news.vo;

import java.util.Date;

import com.bxm.localnews.news.dto.ReplyNewsDTO;
import com.bxm.localnews.news.dto.ReplyPostDTO;
import com.bxm.localnews.news.dto.ReplyVideoDTO;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.vo.BaseBean;
import com.fasterxml.jackson.annotation.JsonFormat;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(description = "我的评论")
public class MyReplysVO extends BaseBean {

    @ApiModelProperty("评论id")
    private Long replyId;

    @ApiModelProperty("新闻id")
    private Long newsId;

    @ApiModelProperty("类型：1.新闻  2.小视频 3.帖子")
    private Byte type;

    @ApiModelProperty("新闻或者小视频封面 此字段为了向前兼容")
    private String newsImgUrl;

    @ApiModelProperty("昵称")
    private String nickName;

    @ApiModelProperty("头像")
    private String headImg;

    @ApiModelProperty("时间戳")
    private String addTimestamp;

    @ApiModelProperty("评论内容")
    private String replyContent;

    @ApiModelProperty("新闻或小视频标题")
    private String title;

    @ApiModelProperty("评论时间")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT)
    private Date addTime;

    @ApiModelProperty("视频播放地址 此字段似乎没什么用")
    private String videoAddress;

    @ApiModelProperty("评论时间")
    private String replyTime;

    private ReplyNewsDTO replyNewsDto;

    private ReplyVideoDTO replyVideoDto;

    private ReplyPostDTO replyPostDto;

    public ReplyPostDTO getReplyPostDto() {
        return replyPostDto;
    }

    public void setReplyPostDto(ReplyPostDTO replyPostDto) {
        this.replyPostDto = replyPostDto;
    }

    public String getVideoAddress() {
        return videoAddress;
    }

    public MyReplysVO setVideoAddress(String videoAddress) {
        this.videoAddress = videoAddress;
        return this;
    }

    public ReplyNewsDTO getReplyNewsDto() {
        return replyNewsDto;
    }

    public MyReplysVO setReplyNewsDto(ReplyNewsDTO replyNewsDto) {
        this.replyNewsDto = replyNewsDto;
        return this;
    }

    public ReplyVideoDTO getReplyVideoDto() {
        return replyVideoDto;
    }

    public MyReplysVO setReplyVideoDto(ReplyVideoDTO replyVideoDto) {
        this.replyVideoDto = replyVideoDto;
        return this;
    }

    public String getAddTimestamp() {
        return this.addTimestamp;
    }

    public void setAddTimestamp(String addTimestamp) {
        this.addTimestamp = addTimestamp;
    }

    public Date getAddTime() {
        return addTime;
    }

    public void setAddTime(Date addTime) {
        this.addTime = addTime;
    }

    public Long getReplyId() {
        return this.replyId;
    }

    public void setReplyId(Long replyId) {
        this.replyId = replyId;
    }

    public Long getNewsId() {
        return this.newsId;
    }

    public void setNewsId(Long newsId) {
        this.newsId = newsId;
    }

    public Byte getType() {
        return type;
    }

    public void setType(Byte type) {
        this.type = type;
    }

    public String getNickName() {
        return this.nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public String getHeadImg() {
        return this.headImg;
    }

    public void setHeadImg(String headImg) {
        this.headImg = headImg;
    }

    public String getReplyContent() {
        return this.replyContent;
    }

    public void setReplyContent(String replyContent) {
        this.replyContent = replyContent;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getNewsImgUrl() {
        return newsImgUrl;
    }

    public void setNewsImgUrl(String newsImgUrl) {
        this.newsImgUrl = newsImgUrl;
    }

    public String getReplyTime() {
        return replyTime;
    }

    public void setReplyTime(String replyTime) {
        this.replyTime = replyTime;
    }
}
