package com.bxm.localnews.news.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@ApiModel(description = "帖子点击数")
@Data
public class PostClickCountVo {

    @ApiModelProperty("帖子id")
    private Long id;

    @ApiModelProperty("审核状态：1通过 2审核中 3拒绝")
    private Integer status;

    @ApiModelProperty("是否精华帖：0否 1是")
    private Byte isBrilliant;

    @ApiModelProperty("是否本地爆料：0否 1是")
    private Byte isBroke;

    @ApiModelProperty("是否优质头条：0否 1是")
    private Byte isRecommend;

    @ApiModelProperty("是否红色章：0否 1是")
    private Byte isRed;

    @ApiModelProperty("是否奖励现金：0否 1是")
    private Byte isCash;

    @ApiModelProperty("用户真实看到的阅读数")
    private Long clickCount;

    @ApiModelProperty("该帖子最终需要达到的用户阅读数量（由真实阅读数量计算而来）")
    private Long finalClickCount;

}
