package com.bxm.localnews.news.domain;

import com.bxm.localnews.news.param.ForumPostListQueryParam;
import com.bxm.localnews.news.param.ForumPostListUserQueryParam;
import com.bxm.localnews.news.param.HomePagePostParam;
import com.bxm.localnews.news.vo.*;
import com.bxm.newidea.component.vo.PageParam;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

@Mapper
public interface ForumPostMapper {

    /**
     * just for updating the statistic data
     * such as  likeCount clickCount reviewCount shareCount collectCount....
     *
     * @param forumPostStatistic
     * @return
     */
    int updateStatisticByPrimaryKeySelective(ForumPostStatistic forumPostStatistic);

    /**
     * 根据id数组获得帖子列表
     * 在首页推荐中展示
     *
     * @param ids
     * @return
     */
    List<ForumPostVo> listPostByIdsInHome(@Param("ids") List<Long> ids);

    /**
     * 根据id数组获得帖子列表
     * 在帖子feed流中展示
     *
     * @param ids
     * @return
     */
    List<ForumPostVo> listPostByIds(@Param("ids") List<Long> ids);

    /**
     * 根据id数组获得帖子列表
     * 在帖子feed流中展示
     *
     * @param param
     * @return
     */
    List<ForumPostVo> listPostByIdsInUser(ForumPostListUserQueryParam param);

    /**
     * 更新帖子中的用户的昵称和头像
     *
     * @param id
     * @param userId
     * @param userImg
     * @param userName
     * @return
     */
    int updateUserInfo(@Param("id") Long id, @Param("userId") Long userId, @Param("userImg") String userImg, @Param("userName") String userName);

    /**
     * 根据id查询帖子详情
     *
     * @param id
     * @return
     */
    ForumPostVo selectByPrimaryKey(Long id);

    /**
     * 查询没有点赞信息的帖子进行补充
     *
     * @return
     */
    List<Long> selectNotExitReplyAndLikeInfo();

    /**
     * 最近半小时发帖未审核数量统计
     *
     * @return
     */
    List<PostCount> selectPendingReviewCount();

    /**
     * 最近半小时发帖数量统计
     *
     * @return
     */
    List<PostCount> selectNewPostCount();

    /**
     * 统计最近半小时的发帖人
     *
     * @return
     */
    int selectUserCount(@Param("areaCode") String areaCode);

    /**
     * 收藏接口[需修改]
     *
     * @param param
     * @return
     */
    List<ForumPostVo> getCollectPostList(ForumPostListUserQueryParam param);

    Integer calcPostNum(@Param("forumId") Long forumId, @Param("topicId") Long topicId, @Param("areaCode") String areaCode);

    List<Long> getPostIdList(@Param("forumId") Long forumId, @Param("topicId") Long topicId, @Param("areaCode") String areaCode);

    List<ForumPostVo> selectForumPostByUser(@Param("userId") Long userId);

    List<Long> listPostRecommend(ForumPostListQueryParam param);

    int insertSelective(ForumPostVo record);

    int updateByPrimaryKeySelective(ForumPostVo record);

    int updateReplyInfoAndCommentByPostId(ForumPostStatistic forumPostStatistic);

    Long getUserIdByPostId(@Param("postId") Long postId);

    List<ForumPostVo> getRewardPostList(Integer size);

    Date selectMaxPublishTime(@Param("areaCode") String areaCode);

    Integer selectPublishPostNumByUserId(Long userId);

    List<ForumPostClickCountVo> getRecentPosts(@Param("clickCountLimit") Integer clickCountLimit,
                                               @Param("displayTimeLimit") Date displayTimeLimit);

    List<ForumPostClickCountVo> getRecentRecommendPosts(@Param("clickCountLimit") Integer clickCountLimit,
                                               @Param("displayTimeLimit") Date displayTimeLimit);

    int batchAddClick(ForumPostClickCountVo forumPostClick);

    List<ForumPostVo> selectAllPosts(PageParam pageParam);

    int getPostLikeNumByUserId(Long userId);

    List<ForumPostVo> listHomePagePostList(HomePagePostParam param);

    int batchUpdatePostVideo(TranscodeMap transcodeMap);

    ForumPostVo selectPostByUserIdAndWeek(@Param("targetUserId") Long targetUserId);

    List<ForumPostVo> batchGetUserPosts(@Param("userIdList") List<Long> userIdList,
                                        @Param("advertTopicId") String advertTopicId,
                                        @Param("isCurrent") Integer isCurrent);

    List<Long> getUpdatedUser(@Param("startTime") Date startTime);

    List<NoteVo> getCarouselNoteList();

    List<NoteVo> batchGetUserNotes(@Param("userIdList") List<Long> userIdList,
                                   @Param("isCurrent") Integer isCurrent);

    /**
     * 根据id查询帖子基础详情
     *
     * @param id
     * @return
     */
    ForumPostVo selectBasicPostById(@Param("id") Long id);

    /**
     * 获取一段时间内的小纸条列表
     *
     * @param startTime 开始时间
     * @param endTime   结束时间
     * @return 小纸条列表
     */
    List<NoteExtraVo> getNoteListByTime(@Param("startTime") Date startTime,
                                   @Param("endTime") Date endTime);


    /**
     * 获取用户最近发布的两条帖子的标题  V3.3.0
     * @param targetUserId
     * @return
     */
    List<ForumPostVo> selectPostTitletByUserId(@Param("targetUserId") Long targetUserId);

    /**
     *  榜单 - 获取最近7日内发帖榜单  得分计算公式：帖子数*10+阅读PV/100+评论数*10，按照热度高低展示 V3.3.0
     * @param areaCode
     * @return
     */
    List<ForumRankVo> getForumRankInfo(@Param("areaCode") String areaCode,@Param("userIds") List<Long> userIds);

    /**
     * 榜单-个人发帖数和热度 V3.3.0
     * @param userId
     * @return
     */
    ForumPostRankForUserVo getForumRankInfoForUser(@Param("userId") Long userId);
}