package com.bxm.localnews.news.dto;

import com.bxm.localnews.news.vo.ForumVo;
import com.bxm.localnews.news.vo.PostImgVo;
import com.bxm.localnews.news.vo.TopicVo;
import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

@ApiModel(description = "帖子概览信息(用于首页)")
@Data
public class ForumPostDTO {

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("帖子标题")
    private String title;

    @ApiModelProperty("作者id")
    private Long userId;

    @ApiModelProperty("作者头像")
    private String userImg;

    @ApiModelProperty("作者名称")
    private String userName;

    @ApiModelProperty("发帖用户所属区域")
    private String areaCode;

    @ApiModelProperty("帖子图片数组,包含视频")
    private List<PostImgVo> postImgList;

    @ApiModelProperty("是否精华帖：0否 1是")
    private Integer isBrilliant;

    @ApiModelProperty("是否本地爆料：0否 1是")
    private Byte isBroke;

    @ApiModelProperty("是否优质头条：0否 1是")
    private Byte isRecommend;

    @ApiModelProperty("是否红色章：0否 1是")
    private Integer isRed;

    @ApiModelProperty("是否奖励现金：0否 1是")
    private Integer isCash;

    @ApiModelProperty("发布时间")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT, timezone = "GMT+8")
    private Date displayTime;

    @ApiModelProperty("阅读数")
    private Integer clickCount;

    @ApiModelProperty("评论数")
    private Integer commentCount;

    @ApiModelProperty("分享数")
    private Integer shareCount;

    @ApiModelProperty("点赞次数")
    private Integer likeCount;

    @ApiModelProperty("当前用户是否已点赞：0否 1是")
    private Integer liked;

    @ApiModelProperty("版块id")
    private Long forumId;

    @ApiModelProperty("版块")
    private ForumVo forum;

    @ApiModelProperty("是否是热文 1：否  2：是 3：爆")
    private Byte hot;

    @ApiModelProperty("状态")
    private Integer status;

    @ApiModelProperty("是否置顶 1：否 2：是")
    private Byte top;

    @ApiModelProperty("是否收藏")
    private Integer collect;

    @ApiModelProperty("帖子文本")
    private String textField;

    @ApiModelProperty("话题列表")
    private List<TopicVo> topicList;

    @ApiModelProperty("分享图片")
    private PostImgVo shareImg;

    @ApiModelProperty("帖子类型(1:普通帖子 2:小纸条)")
    private Byte postType;

}