package com.bxm.localnews.news.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(description = "小视频评论实体")
public class ReplyVideoDTO {

    @ApiModelProperty("小视频id")
    private Long id;

    @ApiModelProperty("评论数")
    private Integer commentCount;

    @ApiModelProperty("小视频地址")
    private String videoUrl;

    /**
     * 作者头像
     */
    @ApiModelProperty("作者头像")
    private String authorImg;

    /**
     * 作者名称
     */
    @ApiModelProperty("作者名称")
    private String author;

    @ApiModelProperty("状态 0:抓取中 1：可用  2：失效")
    private Byte status;

    @ApiModelProperty("是否点赞")
    private Boolean praise;

    @ApiModelProperty("点赞数")
    private Integer likeCount;

    @ApiModelProperty("小视频显示图片")
    private String videoImg;

    public Integer getLikeCount() {
        return likeCount;
    }

    public void setLikeCount(Integer likeCount) {
        this.likeCount = likeCount;
    }

    public Boolean getPraise() {
        return praise;
    }

    public void setPraise(Boolean praise) {
        this.praise = praise;
    }

    public Byte getStatus() {
        return status;
    }

    public void setStatus(Byte status) {
        this.status = status;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getCommentCount() {
        return commentCount;
    }

    public void setCommentCount(Integer commentCount) {
        this.commentCount = commentCount;
    }

    public String getAuthorImg() {
        return authorImg;
    }

    public void setAuthorImg(String authorImg) {
        this.authorImg = authorImg;
    }

    public String getAuthor() {
        return author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getVideoUrl() {
        return videoUrl;
    }

    public void setVideoUrl(String videoUrl) {
        this.videoUrl = videoUrl;
    }

    public String getVideoImg() {
        return videoImg;
    }

    public void setVideoImg(String videoImg) {
        this.videoImg = videoImg;
    }
}
