package com.bxm.localnews.news.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@ApiModel(description = "投票选项信息")
@Data
public class VoteOptionDTO {

    @ApiModelProperty("选项ID")
    private Long optionId;

    @ApiModelProperty("选项文案")
    private String text;

    @ApiModelProperty("选项图片地址，可能为空")
    private String imgUrl;

    @ApiModelProperty("当前选项得票总数")
    private Long total;

    @ApiModelProperty("当前选项百分比占比,无百分号。取值范围：[0,100]")
    private Long percent;

    @ApiModelProperty("选项是否被选中，根据用户上次投票结果获取。默认为false")
    private Boolean checked;
}
