package com.bxm.localnews.news.param;

import com.bxm.newidea.component.vo.PageParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

@ApiModel(description = "帖子列表查询")
public class ForumPostListQueryParam extends PageParam {

    @ApiModelProperty("当前用户id")
    @NotNull
    private Long userId;

    @ApiModelProperty("版块id")
    private Long forumId;

    @ApiModelProperty("主题id")
    private Long topicId;

    @ApiModelProperty("类型：0热门 1精选 2最新 3社区首页")
    @NotNull
    private Integer type;

    @ApiModelProperty("推荐方式，1：下拉刷新，2：上拉刷新，首次进入为下拉刷新")
    private Integer recommendType;

    @ApiModelProperty("区域编码")
    @NotBlank
    private String areaCode;
    @ApiModelProperty("主题id集合：3.3.1新增")
    private String channelIds;

    public Integer getRecommendType() {
        return recommendType;
    }

    public void setRecommendType(Integer recommendType) {
        this.recommendType = recommendType;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Long getForumId() {
        return forumId;
    }

    public void setForumId(Long forumId) {
        this.forumId = forumId;
    }

    public Long getTopicId() {
        return topicId;
    }

    public void setTopicId(Long topicId) {
        this.topicId = topicId;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public String getChannelIds() {
        return channelIds;
    }

    public void setChannelIds(String channelIds) {
        this.channelIds = channelIds;
    }
}
