package com.bxm.localnews.news.param;

import com.bxm.localnews.news.vo.NewsReplyBaseVO;
import com.bxm.newidea.component.vo.PageParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @author zhaoyadong 2018/11/9 11:26
 * @desc
 */
@ApiModel(description = "获取用户评论时时传入的参数")
public class NewsReplyAddParam extends NewsReplyBaseVO {

    @ApiModelProperty(value = "新闻id | 小视频id | 帖子id",required = true)
    private Long newsId;
    @ApiModelProperty(value = "地区编码",required = false)
    private String areaCode;
    @ApiModelProperty("类型  1 新闻 2 小视频，不传则默认是新闻类型 3 帖子")
    private Byte type;
    @ApiModelProperty(value = "删除标记 0：未删除  1：已删除",hidden = true)
    private byte deleteFlag = 0;

    public Byte getType() {
        return type;
    }

    public void setType(Byte type) {
        this.type = type;
    }

    public byte getDeleteFlag() {
        return deleteFlag;
    }

    public void setDeleteFlag(byte deleteFlag) {
        this.deleteFlag = deleteFlag;
    }

    public Long getNewsId() {
        return newsId;
    }

    public void setNewsId(Long newsId) {
        this.newsId = newsId;
    }

    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

}
