package com.bxm.localnews.news.vo;

import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * NewsLike
 * @author 
 */
@Data
@NoArgsConstructor
public class NewsLike implements Serializable {

    private static final long serialVersionUID = -6284700549783300877L;
    /**
     * 主键
     */
    private Long id;

    /**
     * 帖子ID
     */
    private Long newsId;

    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 添加时间
     */
    private Date addTime;

    /**
     * 0:取消点赞，1：点赞
     */
    private Byte type;
    /**
     * 用户头像
     */
    private String headImg;
    /**
     * 用户昵称
     */
    private String userNickname;
    /**
     * 是否展示,0不展示,1展示
     */
    private Byte isShow;
    /**
     * 是否马甲号,0不是,1是
     */
    private Byte isVest;

    public static NewsLike buildNewsLike(Long newsId, Long userId) {
        NewsLike forumPostLike = new NewsLike();
        forumPostLike.setAddTime(new Date());
        forumPostLike.setNewsId(newsId);
        forumPostLike.setUserId(userId);
        return forumPostLike;
    }

    public static NewsLike buildVestNewsLike(Long id, Long newsId, Long userId) {
        NewsLike forumPostLike = new NewsLike();
        forumPostLike.setId(id);
        forumPostLike.setIsShow((byte) 0);
        forumPostLike.setIsVest((byte) 1);
        forumPostLike.setNewsId(newsId);
        forumPostLike.setType((byte) 1);
        forumPostLike.setUserId(userId);
        return forumPostLike;
    }

}