package com.bxm.localnews.news.vo;

import com.bxm.localnews.common.vo.INewsIdSharding;
import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

@ApiModel(description = "新闻回复持久层实体")
public class NewsReply extends NewsReplyBaseVO implements INewsIdSharding {

    @ApiModelProperty("评论ID")
    private Long id;

    @ApiModelProperty("新闻id | 小视频id | 帖子id")
    private Long newsId;

    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT, timezone = "GMT+8")
    private Date addTime;

    @ApiModelProperty("删除标记 0：未删除  1：已删除  2:评论下有回复不删除")
    private byte deleteFlag = 0;

    @ApiModelProperty("回复的根id 直接评论新闻则是0，回复新闻下的评论则显示新闻评论id")
    private Long rootId;

    @ApiModelProperty("回复层次 0:直接评论新闻 1:回复新闻下的评论 2:回复新闻下评论的回复")
    private Byte level;

    @ApiModelProperty("回复点赞数")
    private Integer likeCount;

    @ApiModelProperty("类型：1.新闻  2.小视频, 3社区帖子")
    private Byte type;

    @ApiModelProperty("状态")
    private Byte status;

    @ApiModelProperty("互动值")
    private Integer interactiveCount;

    @ApiModelProperty("评论时间")
    private String replyTime;

    @ApiModelProperty("是否用户删除")
    private Byte isUserDelete;

    @ApiModelProperty("马甲号互动, 0未互动,1已互动")
    private Byte  vestInteract;

    @ApiModelProperty("是否vip 0 :否 1：是")
    private Integer isVip;

    @Override
    public Integer getIsVip() {
        return isVip;
    }

    @Override
    public void setIsVip(Integer isVip) {
        this.isVip = isVip;
    }

    public NewsReply(){
    }

    public NewsReply(String parentUserNickname, String parentHeadImg, Long parentUserId) {
       super(parentUserNickname,parentHeadImg,parentUserId);
    }

    public NewsReply(Long userId, String userNickname, String headImg) {
       super(userId,userNickname,headImg);
    }

    public Integer getLikeCount() {
        return likeCount;
    }

    public void setLikeCount(Integer likeCount) {
        this.likeCount = likeCount;
    }

    public Byte getType() {
        return type;
    }

    public void setType(Byte type) {
        this.type = type;
    }

    public Byte getStatus() {
        return status;
    }

    public void setStatus(Byte status) {
        this.status = status;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public Long getNewsId() {
        return newsId;
    }

    public void setNewsId(Long newsId) {
        this.newsId = newsId;
    }

    public Date getAddTime() {
        return addTime;
    }

    public void setAddTime(Date addTime) {
        this.addTime = addTime;
    }

    public byte getDeleteFlag() {
        return deleteFlag;
    }

    public void setDeleteFlag(byte deleteFlag) {
        this.deleteFlag = deleteFlag;
    }

    public Long getRootId() {
        return rootId;
    }

    public void setRootId(Long rootId) {
        this.rootId = rootId;
    }

    public Byte getLevel() {
        return level;
    }

    public void setLevel(Byte level) {
        this.level = level;
    }

    public Integer getInteractiveCount() {
        return interactiveCount;
    }

    public void setInteractiveCount(Integer interactiveCount) {
        this.interactiveCount = interactiveCount;
    }

    public String getReplyTime() {
        return replyTime;
    }

    public void setReplyTime(String replyTime) {
        this.replyTime = replyTime;
    }

    public Byte getIsUserDelete() {
        return isUserDelete;
    }

    public void setIsUserDelete(Byte isUserDelete) {
        this.isUserDelete = isUserDelete;
    }

    public Byte getVestInteract() {
        return vestInteract;
    }

    public void setVestInteract(Byte vestInteract) {
        this.vestInteract = vestInteract;
    }
}

