package com.bxm.localnews.news.vo;

import com.bxm.newidea.component.vo.BaseBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(description = "新闻回复基础实体")
public class NewsReplyBaseVO extends BaseBean {

    @ApiModelProperty("评论上级id，0为第一级,即新闻下的直接评论")
    private Long parentId;

    @ApiModelProperty("被评论用户id")
    private Long parentUserId;

    @ApiModelProperty("被评论用户昵称")
    private String parentUserNickname;

    @ApiModelProperty("被评论用户头像地址")
    private String parentHeadImg;

    @ApiModelProperty(value = "评论内容",required = true)
    private String replyContent;

    @ApiModelProperty(value = "评论人用户id",required = true)
    private Long userId;

    @ApiModelProperty("是否是vip：0-不是 1-是")
    private Integer isVip;

    @ApiModelProperty("评论人昵称")
    private String userNickname;

    @ApiModelProperty("评论人头像地址")
    private String headImg;

    @ApiModelProperty("评论人是否作者")
    private Boolean userIsAuthor;

    @ApiModelProperty("被评论人是否作者")
    private Boolean parentUserIsAuthor;

    public Integer getIsVip() {
        return isVip;
    }

    public void setIsVip(Integer isVip) {
        this.isVip = isVip;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public Long getParentUserId() {
        return parentUserId;
    }

    public void setParentUserId(Long parentUserId) {
        this.parentUserId = parentUserId;
    }

    public String getParentUserNickname() {
        return parentUserNickname;
    }

    public void setParentUserNickname(String parentUserNickname) {
        this.parentUserNickname = parentUserNickname;
    }

    public String getParentHeadImg() {
        return parentHeadImg;
    }

    public void setParentHeadImg(String parentHeadImg) {
        this.parentHeadImg = parentHeadImg;
    }

    public String getReplyContent() {
        return replyContent;
    }

    public void setReplyContent(String replyContent) {
        this.replyContent = replyContent;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getUserNickname() {
        return userNickname;
    }

    public void setUserNickname(String userNickname) {
        this.userNickname = userNickname;
    }

    public String getHeadImg() {
        return headImg;
    }

    public void setHeadImg(String headImg) {
        this.headImg = headImg;
    }

    public Boolean getUserIsAuthor() {
        return userIsAuthor;
    }

    public void setUserIsAuthor(Boolean userIsAuthor) {
        this.userIsAuthor = userIsAuthor;
    }

    public Boolean getParentUserIsAuthor() {
        return parentUserIsAuthor;
    }

    public void setParentUserIsAuthor(Boolean parentUserIsAuthor) {
        this.parentUserIsAuthor = parentUserIsAuthor;
    }

    public NewsReplyBaseVO() {
    }

    public NewsReplyBaseVO(String parentUserNickname, String parentHeadImg, Long parentUserId) {
        this.parentUserId = parentUserId;
        this.parentUserNickname = parentUserNickname;
        this.parentHeadImg = parentHeadImg;
    }

    public NewsReplyBaseVO(Long userId, String userNickname, String headImg) {
        this.userId = userId;
        this.userNickname = userNickname;
        this.headImg = headImg;
    }
}
