/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.controller;

import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.news.dto.NewsBriefInfoDto;
import com.bxm.localnews.news.param.NewsParam;
import com.bxm.localnews.news.service.NewsService;
import com.bxm.localnews.news.vo.NewsDetailVO;
import com.bxm.localnews.news.vo.NewsVO;
import com.bxm.localnews.news.vo.PostImgVo;
import com.bxm.newidea.component.util.WebUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"4-96 [\u5185\u90e8]\u65b0\u95fb\u76f8\u5173\u63a5\u53e3"})
@RestController
@RequestMapping(value={"facade/news"})
public class NewsFacadeController {
    @Resource
    private NewsService newsService;

    @ApiOperation(value="4-96-1 \u83b7\u53d6\u65b0\u95fb\u7b80\u7565\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="newsId", value="\u65b0\u95fbID", required=true), @ApiImplicitParam(name="areaCode", value="\u8bbf\u95ee\u8bf7\u6c42\u6765\u6e90\u7528\u6237\u6240\u5c5e\u533a\u57df\u7f16\u7801"), @ApiImplicitParam(name="userId", value="\u8bbf\u95ee\u63a5\u53e3\u7684\u7528\u6237ID")})
    @GetMapping(value={"briefInfo"})
    public ResponseEntity<NewsBriefInfoDto> getBriefInfo(@RequestParam(value="newsId") Long newsId, @RequestParam(value="areaCode", required=false) String areaCode, @RequestParam(value="userId", required=false) Long userId, HttpServletRequest request) {
        String ip = WebUtils.getIpAddr((HttpServletRequest)request);
        NewsParam param = new NewsParam();
        param.setAreaCode(areaCode);
        param.setNewsId(newsId);
        param.setUserId(userId);
        Json newsDetailVOJson = this.newsService.getNewsDetailById(param, new BasicParam(), ip);
        NewsVO result = ((NewsDetailVO)newsDetailVOJson.getResult()).getNews();
        NewsBriefInfoDto newsBriefInfoDto = new NewsBriefInfoDto();
        newsBriefInfoDto.setId(result.getId());
        newsBriefInfoDto.setTitle(result.getTitle());
        newsBriefInfoDto.setHasVote(Boolean.valueOf(false));
        PostImgVo shareImgVo = result.getShareImg();
        if (null != shareImgVo) {
            newsBriefInfoDto.setConvertImgUrl(shareImgVo.getImgUrl());
        }
        return ResponseEntity.ok((Object)newsBriefInfoDto);
    }
}

