package com.bxm.localnews.news.dto;

import com.bxm.newidea.component.vo.BaseBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

@ApiModel(description = "回复记录")
public class VideoReplyDto extends BaseBean {

    @ApiModelProperty("回复记录ID")
    private Long id;

    @ApiModelProperty("回复内容")
    private String comment;

    @ApiModelProperty("回复用户ID")
    private Long userId;

    @ApiModelProperty("回复用户名称")
    private String userName;

    @ApiModelProperty("回复用户头像")
    private String userImg;

    @ApiModelProperty("回复点赞数")
    private Integer likeCount;

    @ApiModelProperty("评论是否已删除")
    private int deleleFlag;

    @ApiModelProperty("添加时间")
    private Date addTime;

    @ApiModelProperty("是否点赞 1：已点赞 0：未点赞")
    private Integer isLike = 0;

    @ApiModelProperty("原始回复内容,如果是对其他的回复进行的回复，则会有值，否则为null")
    private VideoReplyDto sourceReply;

    public VideoReplyDto getSourceReply() {
        return sourceReply;
    }

    public void setSourceReply(VideoReplyDto sourceReply) {
        this.sourceReply = sourceReply;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getComment() {
        return comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserImg() {
        return userImg;
    }

    public void setUserImg(String userImg) {
        this.userImg = userImg;
    }

    public int getDeleleFlag() {
        return deleleFlag;
    }

    public void setDeleleFlag(int deleleFlag) {
        this.deleleFlag = deleleFlag;
    }

    public Integer getLikeCount() {
        return likeCount;
    }

    public void setLikeCount(Integer likeCount) {
        this.likeCount = likeCount;
    }

    public Date getAddTime() {
        return addTime;
    }

    public void setAddTime(Date addTime) {
        this.addTime = addTime;
    }

    public Integer getIsLike() {
        return isLike;
    }

    public void setIsLike(Integer isLike) {
        this.isLike = isLike;
    }
}
