package com.bxm.localnews.news.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(description = "视频屏蔽参数")
public class VideoBlackParam {

    @ApiModelProperty(value = "屏蔽的视频ID", required = true)
    private Long videoId;

    @ApiModelProperty(value = "用户ID", required = true)
    private Long userId;

    @ApiModelProperty(value = "屏蔽类型，0：不感兴趣，1：举报", required = true)
    private int type;

    @ApiModelProperty("如果屏蔽类型为1，提供具体的举报信息文案,MAX[200]")
    private String reason;

    public Long getVideoId() {
        return videoId;
    }

    public void setVideoId(Long videoId) {
        this.videoId = videoId;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getReason() {
        return reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

}
