package com.bxm.localnews.news.vo;

import com.bxm.localnews.news.dto.VideoDto;
import com.bxm.localnews.thirdparty.dto.AdvertDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

@ApiModel(description = "推荐新闻的返回结果")
public class News4Client {

    @ApiModelProperty("推荐新闻，包括视频新闻、组图新闻")
    private News news;

    @ApiModelProperty("插入的信息流广告,可能为null")
    private AdvertDTO advert;

    @ApiModelProperty("插入的小视频列表，可能为null。列表长度12")
    private List<VideoDto> videos;

    public News4Client() {
    }

    public News4Client(News news, AdvertDTO advert) {
        this.news = news;
        this.advert = advert;
    }

    public News4Client(List<VideoDto> videos) {
        this.videos = videos;
    }

    public List<VideoDto> getVideos() {
        return videos;
    }

    public void setVideos(List<VideoDto> videos) {
        this.videos = videos;
    }

    public News getNews() {
        return this.news;
    }

    public void setNews(News news) {
        this.news = news;
    }

    public AdvertDTO getAdvert() {
        return this.advert;
    }

    public void setAdvert(AdvertDTO advert) {
        this.advert = advert;
    }

}
