package com.bxm.localnews.news.vo;

import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

@ApiModel(description = "新闻查询返回元数据")
public class NewsMeta {

    @ApiModelProperty("新闻总数")
    private int newsCount;

    @ApiModelProperty("当前查询页数,调用推荐接口时传递")
    private int curPage;

    @ApiModelProperty("新闻详情")
    private List<News4Client> list;

    public NewsMeta() {
    }

    public NewsMeta(int newsCount, List<News4Client> list) {
        this.newsCount = newsCount;
        this.list = list;
    }

    public int getCurPage() {
        return curPage;
    }

    public void setCurPage(int curPage) {
        this.curPage = curPage;
    }

    public int getNewsCount() {
        return newsCount;
    }

    public void setNewsCount(int newsCount) {
        this.newsCount = newsCount;
    }

    public void addNews4Client(News4Client news4Client) {
        getList().add(news4Client);
    }

    public List<News4Client> getList() {
        if (list == null) {
            list = Lists.newArrayList();
        }
        return list;
    }

    public void setList(List<News4Client> list) {
        this.list = list;
    }

}
