package com.bxm.localnews.news.vo;

import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.common.vo.IUserIdSharding;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(description = "新闻推荐参数")
public class NewsRecommendParam extends BasicParam implements IUserIdSharding {

    @ApiModelProperty(value = "频道ID", required = true)
    private Long kindId;

    @ApiModelProperty(value = "是否热门频道,根据配置的频道ID来判断", hidden = true)
    private Integer isHot;

    @ApiModelProperty("推荐方式，1：下拉刷新，2：上拉刷新，首次进入为下拉刷新")
    private Byte type;

    @ApiModelProperty("拉取数量，默认20")
    private Integer pagesize = 20;

    @ApiModelProperty("当前是第几次请求（相当于页数），用于控制广告、小视频的插入")
    private Integer curPage = 0;

    @ApiModelProperty(value = "当前请求的用户ID", required = true)
    private Long userId;

    @ApiModelProperty(value = "当前用户的所属区域，用于进行地方新闻推荐")
    private String areaCode;

    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public Integer getCurPage() {
        return curPage;
    }

    public void setCurPage(Integer curPage) {
        this.curPage = curPage;
    }

    public Long getKindId() {
        return this.kindId;
    }

    public void setKindId(Long kindId) {
        this.kindId = kindId;
    }

    public Integer getIsHot() {
        return this.isHot;
    }

    public void setIsHot(Integer isHot) {
        this.isHot = isHot;
    }

    public Byte getType() {
        return this.type;
    }

    public void setType(Byte type) {
        this.type = type;
    }

    public Integer getPagesize() {
        return this.pagesize;
    }

    public void setPagesize(Integer pagesize) {
        this.pagesize = pagesize;
    }

    @Override
    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

}
