package com.bxm.localnews.news.convert.impl;

import com.bxm.localnews.news.param.ForumPostListQueryParam;
import com.bxm.localnews.param.ForumParam;
import com.google.common.base.Converter;
import org.springframework.stereotype.Component;

@Component
public class ForumParamPageConvert extends Converter<ForumPostListQueryParam, ForumParam> {

    @Override
    protected ForumParam doForward(ForumPostListQueryParam param) {
        int operationId = 2;

        if (0 == param.getType()) {
            operationId = 4;
        } else if (1 == param.getType()) {
            operationId = 6;
        } else if (2 == param.getType()) {
            if (null != param.getForumId()) {
                operationId = 5;
            } else {
                operationId = 3;
            }
        }

        ForumParam forumParam = new ForumParam();
        forumParam.setForumId(param.getForumId());
        forumParam.setTopicId(param.getTopicId());
        forumParam.setUserId(param.getUserId());
        forumParam.setActionType(param.getRecommendType());
        forumParam.setAreaCode(param.getAreaCode());
        forumParam.setOperationId(operationId);
        forumParam.setPageNum(param.getPageNum());
        forumParam.setPageSize(param.getPageSize());
        return forumParam;
    }

    @Override
    protected ForumPostListQueryParam doBackward(ForumParam forumParam) {
        return null;
    }
}
