package com.bxm.localnews.news.receiver;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.bxm.localnews.common.vo.RedisMessageBean;
import com.bxm.localnews.news.service.*;
import com.bxm.localnews.news.vo.UserRedundancyInfo;
import com.bxm.newidea.component.service.BaseService;
import org.springframework.beans.factory.annotation.Autowired;

public class Receiver extends BaseService {

    @Autowired
    private NewNewsReplyService newsReplyService;

    @Autowired
    private ForumPostStatisticService forumPostStatisticService;

    @Autowired
    private NewsService newsService;

    public void receiveMessage(String message) {
        logger.debug("收到redis订阅信息:[{}]", JSONObject.toJSON(message));
        RedisMessageBean<UserRedundancyInfo> redisMessageBean =  JSON.parseObject(message,new TypeReference<RedisMessageBean<UserRedundancyInfo>>(){});
        UserRedundancyInfo userRedundancyInfo = redisMessageBean.getEventBody();

        //更新新闻评论和用户评论
        this.newsReplyService.doTriggerUpdateInfo(userRedundancyInfo.getId(), userRedundancyInfo.getNickname(), userRedundancyInfo.getHeadImg());

        //更新帖子表
        this.forumPostStatisticService.doTriggerUpdateInfo(userRedundancyInfo.getId(), userRedundancyInfo.getNickname(), userRedundancyInfo.getHeadImg());

        //更新帖子点赞表
        this.forumPostStatisticService.doTriggerUpdateForumPostLikeInfo(userRedundancyInfo.getId(), userRedundancyInfo.getNickname(), userRedundancyInfo.getHeadImg());

        //更新新闻点赞表
        this.newsService.doTriggerUpdateNewsLikeInfo(userRedundancyInfo.getId(), userRedundancyInfo.getNickname(), userRedundancyInfo.getHeadImg());
    }
}