package com.bxm.localnews.news.service;

import com.bxm.localnews.common.vo.BasicParam;

import org.jsoup.nodes.Document;

public interface AssemblyService {
    /**
     * 需要替换的内容
     *
     * @param target
     * @return
     */
    String assemblyContent(String target, BasicParam basicParam, String ip, byte type, Long userId, String areaCode,Long newsId);

    /**
     * 添加水印
     *
     * @param content
     * @return
     */
    String fixContent(String content, BasicParam basicParam, String ip, byte type, Long userId, String areaCode,Long newsId);

    /**
     * 删除内容中video标签上下的nbsp
     *
     * @param document
     * @return
     */
    String deleteNbspFromVideo(Document document);

    /**
     * 为视频封面增加相应的水印
     *
     * @param imgUrl
     * @return
     */
    String buildVideoCover(String imgUrl);

    /**
     * 为图片增加相应的压缩
     *
     * @param imgUrl
     * @return
     */
    String buildImgCover(String imgUrl);
}
