package com.bxm.localnews.news.service;

import java.util.Date;
import java.util.List;

import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.news.dto.*;
import com.bxm.localnews.news.param.*;
import com.bxm.localnews.news.vo.*;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;

/**
 * 社区相关服务
 */
public interface ForumPostService {

    /**
     * 根据版块或话题获取帖子列表
     *
     * @param param
     * @param basicParam
     * @return
     */
    PageWarper<ForumPostVo> listForumPost(ForumPostListQueryParam param, BasicParam basicParam);

    /**
     * 根据用户及类型获取帖子列表
     *
     * @param param
     * @return
     */
    PageWarper<ForumPostVo> listForumPostByUser(ForumPostListUserQueryParam param);

    /**
     * 根据id获取帖子详情
     *
     * @param id
     * @param userId
     * @param shareUserId
     * @param basicParam
     * @param areaCode
     * @return
     */
    ForumPostVo getForumPostDetail(Long id, Long userId, Long shareUserId, BasicParam basicParam, String areaCode,String ip);

    /**
     * 新增或编辑帖子
     *
     * @param forumBasicVo
     * @return
     */
    Message doCreateOrUpdatePost(ForumBasicVo forumBasicVo, BasicParam basicParam, boolean isDirectlyPassed);

    /**
     * 保存帖子入库
     *
     * @param forumPostVo
     */
    int saveForumPost(ForumPostVo forumPostVo);

    /**
     * 删除帖子
     *
     * @param id
     * @return
     */
    Message deleteForumPost(Long id);

    /**
     * 分享帖子，在分享帖子后可以获得金币，每天会有次数限制
     *
     * @param userId
     * @param newsId
     * @param areaCode
     * @return
     */
    NewsCompleTaskDTO doShareForumPost(Long userId, Long newsId, String areaCode, Byte type, Integer platform);

    /**
     * 填充帖子列表其余参数
     *
     * @param forumPostList
     * @param userId
     * @param areaCode
     * @param isFillTitle
     * @param isInHome 0不在首页,1在首页,2IM中分享
     */
    void fillExtInfo(List<ForumPostVo> forumPostList, Long userId, String areaCode, boolean isFillTitle, byte isInHome);

    /**
     * 对某篇帖子进行点赞操作
     *
     * @param userId
     * @param postId
     * @param type
     * @param areaCode
     */
    void doLikeForumPost(Long userId, Long postId, int type, String areaCode, Integer platform);

    /**
     * 举报某篇帖子
     *
     * @param forumPostInformParam
     * @return
     */
    Message doInformForumPost(ForumPostInformParam forumPostInformParam);

    /**
     * 收藏某篇帖子
     *
     * @param forumPostCollectParam
     */
    void doCollectForumPost(ForumPostCollectParam forumPostCollectParam);

    /**
     * 根据帖子id获取与帖子具有相关性的新闻和帖子
     *
     * @param postId
     * @param userId
     * @param size     数量
     * @param areaCode 地区编号
     * @return
     */
    List<News4Client> listPostDetailRecommend(Long postId, Long userId, Integer size, String areaCode, Integer platform);

    /**
     * 小程序帖子点赞
     *
     * @param postId   帖子id
     * @param userId   用户id
     * @param areaCode 地区编码
     * @return
     */
    PostLikeDto doLikeForumPost(Long postId, Long userId, String areaCode, Integer platform);

    /**
     * 查看详情中的点赞列表
     *
     * @param id
     * @param userId
     * @param devcId
     * @return
     */
    List<ForumPostLikeDTO> getPostLikeDetail(Long id, Long userId, String devcId);


    /**
     * 根据帖子id列表获取帖子列表
     *
     * @param postIds
     * @return
     */
    List<ForumPostVo> getPostListByIds(String postIds);

    /**
     * 本地圈是否有新内容更新
     *
     * @param lastRequestTime
     * @param areaCode
     * @return
     */
    Boolean getContentUpdate(Date lastRequestTime, String areaCode);

    /**
     * 获取现金奖励帖子轮播列表
     *
     * @return
     */
    List<ForumPostVo> getRewardPostList();

    /**
     * 批量替换帖子内容、发帖人emoji编码
     *
     * @return
     */
    Boolean relaceSoftbankEmoji();

    /**
     * 个人主页帖子列表
     *
     * @param param
     * @return
     */
    PageWarper<ForumPostVo> getHomePagePostList(HomePagePostParam param);

}
