package com.bxm.localnews.news.service;


import com.bxm.localnews.news.vo.ForumPostVo;
import com.bxm.localnews.news.vo.PostTopicVO;
import com.bxm.localnews.news.vo.TopicVo;

import java.util.List;

public interface ForumTopicService {

    List<PostTopicVO> listTopicByPostIds(List<Long> postIds, Long userId);

    List<TopicVo> listTopicByPostId(Long postId, Long userId);

    void fillTopicShareInfo(TopicVo topicVo, Long userId);

    /**
     * 查询话题，若size=2，则随机取两条
     *
     * @param areaCode 地区编码
     * @return 分页结果
     */
    List<TopicVo> listTopic(String areaCode, Integer size, Long userId, Integer postPage);

    /**
     * 先从缓存中取列表，若为空则查数据库
     *
     * @param areaCode
     * @return
     */
    List<TopicVo> getTopicList(String areaCode);

    /**
     * 获取话题详情
     *
     * @param id
     * @return
     */
    TopicVo getTopicDetail(Long id, Long userId, String areaCode);

    /**
     * 更新话题
     * @param forumPostVo
     */
    void updateTopic(ForumPostVo forumPostVo);

}
