package com.bxm.localnews.news.service.impl;

import com.bxm.component.mybatis.utils.MybatisBatchBuilder;
import com.bxm.localnews.news.domain.NewsKindMapper;
import com.bxm.localnews.news.domain.UserKindMapper;
import com.bxm.localnews.news.service.UserKindService;
import com.bxm.localnews.news.vo.NewsKind;
import com.bxm.localnews.news.vo.UserKind;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.vo.Message;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

@Service
public class UserKindServiceImpl extends BaseService implements UserKindService {

    private UserKindMapper userKindMapper;

    private NewsKindMapper newsKindMapper;

    @Autowired
    public UserKindServiceImpl(UserKindMapper userKindMapper,
                               NewsKindMapper newsKindMapper) {
        this.userKindMapper = userKindMapper;
        this.newsKindMapper = newsKindMapper;
    }

    @Override
    public Message copyKinds(Long fromUserId, Long toUserId) {
        //查询静默用户的频道
        List<NewsKind> newsKindList = userKindMapper.selectKindByUserId(fromUserId);
        //查询默认添加的频道
        List<NewsKind> newsKindDefaultList = newsKindMapper.selectAll();
        List<NewsKind> newNewsKindList = new ArrayList<>();
        newNewsKindList.addAll(newsKindList);
        newNewsKindList.addAll(newsKindDefaultList);
        //去重排序
        newNewsKindList = newNewsKindList.stream().distinct().sorted(Comparator.comparing(x->x.getSortNo()<x.getSortNo())).collect(Collectors.toList());

        //封装对象
        List<UserKind> userKindList = newNewsKindList.stream().map(x->{
            UserKind userKind = new UserKind();
            userKind.setUserKindId(nextSequence());
            userKind.setKindId(x.getId());
            userKind.setSortNo(x.getSortNo());
            userKind.setUserId(toUserId);
            return userKind;
        }).collect(Collectors.toList());

        this.userKindMapper.deleteByUserId(toUserId);
        MybatisBatchBuilder.create(UserKindMapper.class, userKindList).run(UserKindMapper::insertSelective);

        return Message.build();
    }

}
