package com.bxm.localnews.news.task;

import com.bxm.localnews.news.service.ForumPostFacadeService;
import com.bxm.localnews.news.service.NoteService;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.bxm.newidea.component.tools.DateUtils;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Calendar;
import java.util.Date;

/**
 * 创建即发布的周期定时任务
 */
@Component
@Slf4j
public class CacheUserPostImgTask extends AbstractCronTask<String> {

    @Resource
    private ForumPostFacadeService forumPostFacadeService;

    @Resource
    private NoteService noteService;

    @Override
    protected ReturnT<String> service(String param) {
        log.info(".....................................定时缓存用户帖子图片、小纸条 begin...................................");
        Date startTime = DateUtils.addField(new Date(), Calendar.MINUTE, -30);
        forumPostFacadeService.cacheUserPostImg(startTime);
        noteService.cacheUserNote(startTime);
        log.info(".....................................定时缓存用户帖子图片、小纸条 end.....................................");
        return ReturnT.SUCCESS;
    }

    @Override
    public String taskName() {
        return "cacheUserPostImgTask";
    }

    @Override
    public String cron() {
        return "30 0/30 * * * ? ";
    }

    @Override
    public String description() {
        return "定时缓存用户帖子图片、视频";
    }

}
