package com.bxm.localnews.news.task;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.news.param.OptimizationNoticeParam;
import com.bxm.localnews.news.service.MixRecommandQuarzService;
import com.bxm.newidea.component.schedule.task.AbstractTaskCallback;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * 推荐库 优化通知 定时任务
 */
@Component
@Slf4j
public class OptimizationNoticeTask extends AbstractTaskCallback<OptimizationNoticeParam> {

	@Resource
	private MixRecommandQuarzService mixRecommandQuarzService;

	@Override
	protected ReturnT<String> service(OptimizationNoticeParam param) {
		log.info(" 优化通知 定时任务开始执行,参数为{}", JSONObject.toJSONString(param));
		Boolean flag = mixRecommandQuarzService.doSendOptimizationNotice(param);
		if (flag){
			return ReturnT.SUCCESS;
		}
		return ReturnT.FAIL;
	}

	public static String generateTaskName(Long id) {
		return "optimizationNoticeTask_" + id;
	}

}
