/*
 * Copyright 2019 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.news.task;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.param.PublishNewsBuildParam;
import com.bxm.localnews.news.service.NewsQuartzService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.schedule.task.AbstractTaskCallback;
import com.bxm.newidea.component.tools.StringUtils;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * 定时发布新闻
 */
@Component
@Slf4j
public class PublishNewsTask extends AbstractTaskCallback<PublishNewsBuildParam> {

    @Resource
    private RedisStringAdapter redisStringAdapter;

    @Resource
    private NewsQuartzService newsQuartzService;

    @Override
    protected ReturnT<String> service(PublishNewsBuildParam param) {
        log.debug("定时新闻发布开始执行:", JSON.toJSONString(param));
        if (null != param) {
            String areaCodes = param.getAreaCodes();
            Long newsId = param.getNewsId();
            newsQuartzService.publishNews(newsId);
            this.clearRedisCacheOfTopNewsList(areaCodes);
            log.info("id为{}的新闻发布成功", newsId);
        }
        return ReturnT.SUCCESS;

    }

    /**
     * 清除首页置顶新闻列表缓存
     */
    private void clearRedisCacheOfTopNewsList(String areaCodeStr) {
        log.info("清除首页置顶新闻列表缓存开始执行:");
        if (StringUtils.isNotEmpty(areaCodeStr)) {
            String[] areaCodes = areaCodeStr.split(",");
            for (String areaCode : areaCodes) {
                KeyGenerator keyGenerator = RedisConfig.TOP_NEW_OF_AREA_LIST.copy().appendKey(areaCode);
                redisStringAdapter.remove(keyGenerator);
            }
        } else {
            // 清除全国性置顶新闻缓存
            redisStringAdapter.remove(RedisConfig.TOP_NEW_OF_WHOLE_COUNTRY_LIST);
        }
    }

    public static String generateTaskName(Long newsId) {
        return "publishNewsTask_" + newsId;
    }

}
