package com.bxm.localnews.news.service;

import java.util.List;

import com.bxm.localnews.activity.dto.NewShareGoldDTO;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.common.vo.MPage;
import com.bxm.localnews.news.param.ExecGoldParam;
import com.bxm.localnews.news.param.NewsParam;
import com.bxm.localnews.news.vo.*;

/**
 * Created by hsq 10:31 2018/2/8
 */
public interface NewsService {

    /**
     * 获取新闻详情页跳转地址
     *
     * @param id
     * @param userId
     * @param type   1：详情地址  2：分享地址 3：搜索文章查看详情地址 4:广告分享链接（newsId为广告id）
     * @return
     */
    Json<NewsUrlVo> getUrl(Long id, Long userId, Byte type);

    /**
     * 执行阅读文章奖励机制
     *
     * @param execGoldParam
     * @return
     */
    Json<NewsGoldMeta> execGetGold(ExecGoldParam execGoldParam);

    /**
     * 新闻视频推荐
     *
     * @param newsId
     * @return
     */
    Json<List<News4Client>> queryRecommendNews(Long newsId, Long userId);

    /**
     * 组图推荐
     *
     * @param newsId
     * @return
     */
    Json<List<News4Client>> queryRecommendNews4ImgNews(Long newsId);

    /**
     * 新闻分享成功金币赠送
     *
     * @param newsId
     * @param userId
     * @return
     */
    Json<NewShareGoldDTO> saveShareNews(Long newsId, Long userId);

    /**
     * 新闻详情
     *
     * @param newsParam
     * @return
     */
    Json<NewsDetailVO> execGetSyDetail(NewsParam newsParam);

    /**
     * 视频上下刷新
     *
     * @param userId
     * @param type   类型
     * @param kindId 频道
     * @return
     */
    Json<NewsMeta> refreshVideo(Long userId, Byte type, Integer kindId);

    /**
     * @param userId
     * @param keyword 关键字
     * @param page
     * @return
     */
    List<News> searchNews(Long userId, String keyword, MPage page);

    /**
     * 阅读文章返回时调用
     *
     * @param newsId
     * @param userId
     * @param viewTime   阅读时间
     * @param tabType    是否读取到文章末尾 1：否   2：是
     * @param advertShow 广告位是否展示出来 1：否  2：是
     * @return
     */
    Json getBack(Long newsId, Long userId, Integer viewTime, String tabType, String advertShow);

    /**
     * 获取热门搜索标题
     *
     * @return
     */
    Json<List<NewsSearchWord>> searchHotTitle();

    /**
     * 视频分类
     *
     * @return
     */
    Json<List<NewsKind>> searchKinds();

    /**
     * 无效视频重新抓取
     *
     * @param newsId
     * @return
     */
    Json<FailVideo> getFailVideo(Long newsId);

    /**
     * 点击次数+1
     *
     * @param newsId
     * @return
     */
    Json addClick(Long newsId);

    void delNewsTag();

}
