package com.bxm.localnews.news.strategy;

import com.bxm.localnews.common.constant.AppConst;
import com.bxm.localnews.common.constant.TaskEnum;
import com.bxm.localnews.news.domain.NewsRecordMapper;
import com.bxm.localnews.news.param.ExecGoldCalParam;
import com.bxm.localnews.news.vo.News;
import com.bxm.localnews.news.vo.NewsGoldMeta;
import com.bxm.localnews.news.vo.NewsRecord;
import com.bxm.localnews.user.service.UserAmountService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;

import static com.bxm.localnews.common.constant.AppConst.NN_GOLD;

/**
 * 视频阅读奖励策略
 */
@Service
public class GoldCalculatorOfVideo extends AbstractGoldenStrategy {

    @Resource
    private NewsRecordMapper newsRecordMapper;

    @Resource
    private UserAmountService userAmountService;

    public GoldCalculatorOfVideo() {
    }

    @Override
    public void calculator(ExecGoldCalParam execGoldCalParam) {
        Long newsId = execGoldCalParam.getNewsId();
        Long userId = execGoldCalParam.getUserId();
        Integer viewTime = execGoldCalParam.getViewTime();
        String advertShow = execGoldCalParam.getAdvertShow();
        NewsGoldMeta newsGoldMeta = execGoldCalParam.getNewsGoldMeta();
        NewsRecord nRecord = execGoldCalParam.getnRecord();

        byte goldType = AppConst.UN_GOLD;


        //是否验证通过
        if (checkLegalWithFlag(viewTimeFlag, advertShowFlag, execGoldCalParam.isSuspendFlag())) {
            Long reward = missionService.completeTask(userId, TaskEnum.TASK_VIDEO_READ, newsId.toString());
            if (reward != null) {
                goldType = NN_GOLD;
                nRecord.setGetGoldTime(new Date());
                nRecord.setIntervalNum(randomInterval);
                newsGoldMeta.setGoldNum(reward.intValue());
                newsGoldMeta.setTotalGold(userAmountService.selectGoldBalanceByUserId(userId));
            }
        }

        nRecord.setGetGold(goldType);
        nRecord.setUserId(userId);
        this.newsRecordMapper.updateByPrimaryKeySelective(nRecord);

        newsGoldMeta.setTaskName(TaskEnum.TASK_VIDEO_READ.getDesc());
        newsGoldMeta.setGoldType(goldType);


    }

    @Override
    public boolean support(int newsType) {
        return AppConst.NEWS.VIDEO == newsType;
    }

    /**
     * 得到视频时长
     *
     * @param news
     * @return
     */
    private Integer getConfigTime(News news) {
        String videoScal = "0";
        double dou = Double.valueOf(videoScal) * news.getVideoLen();
        return (int) Math.floor(dou);
    }

    private boolean checkLegalWithFlag(boolean viewTimeFlag, boolean advertShowFlag, boolean isSuspendFlag) {
        return viewTimeFlag && advertShowFlag && isSuspendFlag;
    }

}
