package com.bxm.localnews.news.service.impl;

import com.bxm.localnews.news.domain.NewsRecommendedMapper;
import com.bxm.localnews.news.service.NewsRecommendedService;
import com.bxm.newidea.component.vo.Message;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

@Service
public class NewsRecommendedServiceImpl implements NewsRecommendedService {

    private NewsRecommendedMapper newsRecommendedMapper;

    @Autowired
    public NewsRecommendedServiceImpl(NewsRecommendedMapper newsRecommendedMapper) {
        this.newsRecommendedMapper = newsRecommendedMapper;
    }

    @Override
    public boolean copyRecommendeds(Long fromUid, Long toUid, Date time) {
        return this.newsRecommendedMapper.copyRecommendeds(fromUid, toUid, time) > 0;
    }

    @Override
    public Message deleteByUserId(Long userId) {
        return Message.build(this.newsRecommendedMapper.deleteByUserId(userId));
    }

}
